/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AdministrativeOperationRequestControl
extends Control {
    @NotNull
    private static final String JSON_FIELD_MESSAGE = "message";
    @NotNull
    public static final String ADMINISTRATIVE_OPERATION_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.11";
    private static final long serialVersionUID = 4958642483402677725L;
    @Nullable
    private final String message;

    public AdministrativeOperationRequestControl() {
        this((String)null);
    }

    public AdministrativeOperationRequestControl(@Nullable String message) {
        this(false, message);
    }

    public AdministrativeOperationRequestControl(boolean isCritical, @Nullable String message) {
        super(ADMINISTRATIVE_OPERATION_REQUEST_OID, isCritical, AdministrativeOperationRequestControl.encodeValue(message));
        this.message = message;
    }

    public AdministrativeOperationRequestControl(@NotNull Control control) {
        super(control);
        this.message = control.hasValue() ? control.getValue().stringValue() : null;
    }

    @Nullable
    private static ASN1OctetString encodeValue(@Nullable String message) {
        if (message == null) {
            return null;
        }
        return new ASN1OctetString(message);
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_ADMINISTRATIVE_OPERATION_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        JSONObject valueObject = this.message == null ? JSONObject.EMPTY_OBJECT : new JSONObject(new JSONField(JSON_FIELD_MESSAGE, this.message));
        return new JSONObject(new JSONField("oid", ADMINISTRATIVE_OPERATION_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_ADMINISTRATIVE_OPERATION_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", valueObject));
    }

    @NotNull
    public static AdministrativeOperationRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, false);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new AdministrativeOperationRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        if (valueObject == null) {
            return new AdministrativeOperationRequestControl();
        }
        String message = valueObject.getFieldAsString(JSON_FIELD_MESSAGE);
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_MESSAGE)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ADMIN_OP_REQUEST_JSON_CONTROL_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new AdministrativeOperationRequestControl(jsonControl.getCriticality(), message);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AdministrativeOperationRequestControl(");
        if (this.message != null) {
            buffer.append("message='");
            buffer.append(this.message);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

