/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import com.github.fge.lambdas.Throwing;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.lib.netty.CertificateReloadable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractServerFactory
implements Configurable,
CertificateReloadable.Factory {
    private List<AbstractConfigurableAsyncServer> servers;
    private HierarchicalConfiguration<ImmutableNode> config;

    protected abstract List<AbstractConfigurableAsyncServer> createServers(HierarchicalConfiguration<ImmutableNode> var1) throws Exception;

    public void configure(HierarchicalConfiguration<ImmutableNode> config) {
        this.config = config;
    }

    @PostConstruct
    public void init() throws Exception {
        this.servers = this.createServers(this.config);
        this.servers.parallelStream().forEach(Throwing.consumer(AbstractConfigurableAsyncServer::init).sneakyThrow());
    }

    public List<AbstractConfigurableAsyncServer> getServers() {
        return this.servers;
    }

    @PreDestroy
    public void destroy() {
        Flux.fromIterable(this.servers).flatMap(asyncServer -> Mono.fromRunnable(asyncServer::destroy)).then().block();
    }

    public Stream<AbstractConfigurableAsyncServer> certificatesReloadable() {
        return this.getServers().stream().filter(AbstractConfigurableAsyncServer::isEnabled);
    }
}

