/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.springframework.jdbc.datasource.UserCredentialsDataSourceAdapter;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class IsolationLevelDataSourceAdapter
extends UserCredentialsDataSourceAdapter {
    static final Map<String, Integer> constants = Map.of("ISOLATION_DEFAULT", -1, "ISOLATION_READ_UNCOMMITTED", 1, "ISOLATION_READ_COMMITTED", 2, "ISOLATION_REPEATABLE_READ", 4, "ISOLATION_SERIALIZABLE", 8);
    @Nullable
    private Integer isolationLevel;

    public final void setIsolationLevelName(String constantName) throws IllegalArgumentException {
        Assert.hasText((String)constantName, (String)"'constantName' must not be null or blank");
        Integer isolationLevel = constants.get(constantName);
        Assert.notNull((Object)isolationLevel, (String)"Only isolation constants allowed");
        this.setIsolationLevel(isolationLevel);
    }

    public void setIsolationLevel(int isolationLevel) {
        Assert.isTrue((boolean)constants.containsValue(isolationLevel), (String)"Only values of isolation constants allowed");
        this.isolationLevel = isolationLevel != -1 ? Integer.valueOf(isolationLevel) : null;
    }

    @Nullable
    protected Integer getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    protected Connection doGetConnection(@Nullable String username, @Nullable String password) throws SQLException {
        Integer isolationLevelToUse;
        Connection con = super.doGetConnection(username, password);
        Boolean readOnlyToUse = this.getCurrentReadOnlyFlag();
        if (readOnlyToUse != null) {
            con.setReadOnly(readOnlyToUse);
        }
        if ((isolationLevelToUse = this.getCurrentIsolationLevel()) != null) {
            con.setTransactionIsolation(isolationLevelToUse);
        }
        return con;
    }

    @Nullable
    protected Integer getCurrentIsolationLevel() {
        Integer isolationLevelToUse = TransactionSynchronizationManager.getCurrentTransactionIsolationLevel();
        if (isolationLevelToUse == null) {
            isolationLevelToUse = this.getIsolationLevel();
        }
        return isolationLevelToUse;
    }

    @Nullable
    protected Boolean getCurrentReadOnlyFlag() {
        boolean txReadOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
        return txReadOnly ? Boolean.TRUE : null;
    }
}

