/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.utils.ReferenceCounter;

public class ReferenceCounterUtil
implements ReferenceCounter,
AutoCloseable {
    private Runnable task;
    private final Executor executor;
    private volatile int use = 0;
    private static final AtomicIntegerFieldUpdater<ReferenceCounterUtil> useUpdater = AtomicIntegerFieldUpdater.newUpdater(ReferenceCounterUtil.class, "use");

    public ReferenceCounterUtil() {
        this.executor = null;
        this.task = null;
    }

    public ReferenceCounterUtil(Executor executor) {
        this.executor = executor;
    }

    public ReferenceCounterUtil(Runnable runnable, Executor executor) {
        this.setTask(runnable);
        this.executor = executor;
    }

    public ReferenceCounterUtil(Runnable runnable) {
        this.setTask(runnable);
        this.executor = null;
    }

    @Override
    public void setTask(Runnable task) {
        this.task = task;
    }

    @Override
    public Runnable getTask() {
        return this.task;
    }

    @Override
    public int increment() {
        return useUpdater.incrementAndGet(this);
    }

    @Override
    public int decrement() {
        int value = useUpdater.decrementAndGet(this);
        if (value == 0) {
            this.execute();
        }
        return value;
    }

    public void exhaust() {
        this.execute();
        useUpdater.set(this, 0);
    }

    private void execute() {
        if (this.task != null) {
            if (this.executor != null) {
                this.executor.execute(this.task);
            } else {
                this.task.run();
            }
        }
    }

    @Override
    public void check() {
        if (this.getCount() <= 0) {
            this.execute();
        }
    }

    @Override
    public int getCount() {
        return useUpdater.get(this);
    }

    @Override
    public void close() {
        this.decrement();
    }
}

