/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.codec.multipart.DefaultPartEvents;
import org.springframework.http.codec.multipart.PartEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface FilePartEvent
extends PartEvent {
    default public String filename() {
        String filename = this.headers().getContentDisposition().getFilename();
        Assert.state((filename != null ? 1 : 0) != 0, (String)"No filename found");
        return filename;
    }

    public static Flux<FilePartEvent> create(String name, Resource resource) {
        return FilePartEvent.create(name, resource, null);
    }

    public static Flux<FilePartEvent> create(String name, Resource resource, @Nullable Consumer<HttpHeaders> headersConsumer) {
        try {
            return FilePartEvent.create(name, resource.getFile().toPath(), headersConsumer);
        }
        catch (IOException ex) {
            return Flux.error((Throwable)ex);
        }
    }

    public static Flux<FilePartEvent> create(String name, Path path) {
        return FilePartEvent.create(name, path, null);
    }

    public static Flux<FilePartEvent> create(String name, Path path, @Nullable Consumer<HttpHeaders> headersConsumer) {
        Assert.hasLength((String)name, (String)"Name must not be empty");
        Assert.notNull((Object)path, (String)"Path must not be null");
        return Flux.defer(() -> {
            String pathName = StringUtils.cleanPath((String)path.toString());
            MediaType contentType = MediaTypeFactory.getMediaType(pathName).orElse(MediaType.APPLICATION_OCTET_STREAM);
            String filename = StringUtils.getFilename((String)pathName);
            if (filename == null) {
                return Flux.error((Throwable)new IllegalArgumentException("Invalid file: " + pathName));
            }
            Flux contents = DataBufferUtils.read((Path)path, (DataBufferFactory)DefaultDataBufferFactory.sharedInstance, (int)8192, (OpenOption[])new OpenOption[0]);
            return FilePartEvent.create(name, filename, contentType, (Flux<DataBuffer>)contents, headersConsumer);
        });
    }

    public static Flux<FilePartEvent> create(String partName, String filename, MediaType contentType, Flux<DataBuffer> contents) {
        return FilePartEvent.create(partName, filename, contentType, contents, null);
    }

    public static Flux<FilePartEvent> create(String partName, String filename, MediaType contentType, Flux<DataBuffer> contents, @Nullable Consumer<HttpHeaders> headersConsumer) {
        Assert.hasLength((String)partName, (String)"PartName must not be empty");
        Assert.hasLength((String)filename, (String)"Filename must not be empty");
        Assert.notNull((Object)contentType, (String)"ContentType must not be null");
        Assert.notNull(contents, (String)"Contents must not be null");
        return Flux.defer(() -> {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(contentType);
            headers.setContentDisposition(ContentDisposition.formData().name(partName).filename(filename, StandardCharsets.UTF_8).build());
            if (headersConsumer != null) {
                headersConsumer.accept(headers);
            }
            return contents.map(content -> DefaultPartEvents.file(headers, content, false)).concatWith((Publisher)Mono.just((Object)DefaultPartEvents.file(headers)));
        });
    }
}

