/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.netty;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.util.DurationParser;

public class MaxConnectionLifespanHandler
implements ConnectHandler<SMTPSession> {
    public static final Response NOOP = new Response(){

        public String getRetCode() {
            return "";
        }

        public List<CharSequence> getLines() {
            return Collections.emptyList();
        }

        public boolean isEndSession() {
            return false;
        }
    };
    private Optional<Duration> connectionLifespan = Optional.empty();

    public void init(Configuration config) throws ConfigurationException {
        this.connectionLifespan = Optional.of(DurationParser.parse((String)Optional.ofNullable(config.getString("duration", null)).orElseThrow(() -> new ConfigurationRuntimeException("'duration' configuration property is compulsary"))));
    }

    public Response onConnect(SMTPSession session) {
        this.connectionLifespan.ifPresent(duration -> session.schedule(() -> ((SMTPSession)session).close(), duration));
        return NOOP;
    }
}

