/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.abstractstore;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FetchConfigurationImpl;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.Id;
import org.apache.openjpa.util.ImplHelper;

public abstract class AbstractStoreManager
implements StoreManager {
    protected StoreContext ctx;

    @Override
    public final void setContext(StoreContext ctx) {
        this.ctx = ctx;
        this.open();
    }

    public StoreContext getContext() {
        return this.ctx;
    }

    protected void open() {
    }

    @Override
    public void beginOptimistic() {
    }

    @Override
    public void rollbackOptimistic() {
    }

    @Override
    public void begin() {
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public boolean syncVersion(OpenJPAStateManager sm, Object edata) {
        return true;
    }

    @Override
    public abstract boolean initialize(OpenJPAStateManager var1, PCState var2, FetchConfiguration var3, Object var4);

    @Override
    public abstract boolean load(OpenJPAStateManager var1, BitSet var2, FetchConfiguration var3, int var4, Object var5);

    @Override
    public Collection<Object> loadAll(Collection<OpenJPAStateManager> sms, PCState state, int load, FetchConfiguration fetch, Object edata) {
        return ImplHelper.loadAll(sms, this, state, load, fetch, edata);
    }

    @Override
    public Collection<Exception> flush(Collection<OpenJPAStateManager> sms) {
        LinkedList<OpenJPAStateManager> pNew = new LinkedList<OpenJPAStateManager>();
        LinkedList<OpenJPAStateManager> pNewUpdated = new LinkedList<OpenJPAStateManager>();
        LinkedList<OpenJPAStateManager> pNewFlushedDeleted = new LinkedList<OpenJPAStateManager>();
        LinkedList<OpenJPAStateManager> pDirty = new LinkedList<OpenJPAStateManager>();
        LinkedList<OpenJPAStateManager> pDeleted = new LinkedList<OpenJPAStateManager>();
        for (OpenJPAStateManager sm : sms) {
            if (sm.getPCState() == PCState.PNEW && !sm.isFlushed()) {
                pNew.add(sm);
                continue;
            }
            if (sm.getPCState() == PCState.PNEW && sm.isFlushed()) {
                pNewUpdated.add(sm);
                continue;
            }
            if (sm.getPCState() == PCState.PNEWFLUSHEDDELETED) {
                pNewFlushedDeleted.add(sm);
                continue;
            }
            if (sm.getPCState() == PCState.PDIRTY) {
                pDirty.add(sm);
                continue;
            }
            if (sm.getPCState() != PCState.PDELETED) continue;
            pDeleted.add(sm);
        }
        if (pNew.isEmpty() && pNewUpdated.isEmpty() && pNewFlushedDeleted.isEmpty() && pDirty.isEmpty() && pDeleted.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.flush(pNew, pNewUpdated, pNewFlushedDeleted, pDirty, pDeleted);
    }

    @Override
    public void beforeStateChange(OpenJPAStateManager sm, PCState fromState, PCState toState) {
    }

    @Override
    public boolean assignObjectId(OpenJPAStateManager sm, boolean preFlush) {
        ClassMetaData meta = sm.getMetaData();
        if (meta.getIdentityType() == 2) {
            return ApplicationIds.assign(sm, this, preFlush);
        }
        Object val = ImplHelper.generateIdentityValue(this.ctx, meta, 6);
        return this.assignDataStoreId(sm, val);
    }

    protected boolean assignDataStoreId(OpenJPAStateManager sm, Object val) {
        ClassMetaData meta = sm.getMetaData();
        if (val == null && meta.getIdentityStrategy() != 1) {
            return false;
        }
        if (val == null) {
            val = this.getDataStoreIdSequence(meta).next(this.ctx, meta);
        }
        sm.setObjectId(this.newDataStoreId(val, meta));
        return true;
    }

    @Override
    public boolean assignField(OpenJPAStateManager sm, int field, boolean preFlush) {
        FieldMetaData fmd = sm.getMetaData().getField(field);
        Object val = ImplHelper.generateFieldValue(this.ctx, fmd);
        if (val == null) {
            return false;
        }
        sm.store(field, val);
        return true;
    }

    @Override
    public Class<?> getManagedType(Object oid) {
        if (oid instanceof Id) {
            return ((Id)oid).getType();
        }
        return null;
    }

    @Override
    public Class<?> getDataStoreIdType(ClassMetaData meta) {
        return Id.class;
    }

    @Override
    public Object copyDataStoreId(Object oid, ClassMetaData meta) {
        Id id = (Id)oid;
        return new Id(meta.getDescribedType(), id.getId(), id.hasSubclasses());
    }

    @Override
    public Object newDataStoreId(Object val, ClassMetaData meta) {
        while (meta.getPCSuperclass() != null) {
            meta = meta.getPCSuperclassMetaData();
        }
        return Id.newInstance(meta.getDescribedType(), val);
    }

    @Override
    public void retainConnection() {
    }

    @Override
    public void releaseConnection() {
    }

    @Override
    public Object getClientConnection() {
        return null;
    }

    @Override
    public abstract ResultObjectProvider executeExtent(ClassMetaData var1, boolean var2, FetchConfiguration var3);

    @Override
    public StoreQuery newQuery(String language) {
        return null;
    }

    @Override
    public FetchConfiguration newFetchConfiguration() {
        return new FetchConfigurationImpl();
    }

    @Override
    public int compareVersion(OpenJPAStateManager state, Object v1, Object v2) {
        if (v1 == null || v2 == null) {
            return 4;
        }
        int compare = ((Comparable)v1).compareTo((Comparable)v2);
        if (compare < 0) {
            return 2;
        }
        if (compare == 0) {
            return 3;
        }
        return 1;
    }

    @Override
    public Seq getDataStoreIdSequence(ClassMetaData forClass) {
        return this.ctx.getConfiguration().getSequenceInstance();
    }

    @Override
    public Seq getValueSequence(FieldMetaData forField) {
        return null;
    }

    @Override
    public boolean cancelAll() {
        return false;
    }

    @Override
    public void close() {
    }

    protected abstract Collection<Exception> flush(Collection<OpenJPAStateManager> var1, Collection<OpenJPAStateManager> var2, Collection<OpenJPAStateManager> var3, Collection<OpenJPAStateManager> var4, Collection<OpenJPAStateManager> var5);

    protected OpenJPAConfiguration newConfiguration() {
        return new OpenJPAConfigurationImpl();
    }

    protected Collection<String> getUnsupportedOptions() {
        HashSet<String> c = new HashSet<String>();
        c.add("openjpa.option.Optimistic");
        c.add("openjpa.option.DatastoreIdentity");
        c.add("openjpa.option.IncrementalFlush");
        c.add("openjpa.option.AutoassignValue");
        c.add("openjpa.option.IncrementValue");
        c.add("openjpa.option.DataStoreConnection");
        return c;
    }

    protected String getPlatform() {
        return this.getClass().getName();
    }
}

