/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.postgres;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;
import org.jooq.Binding;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;
import org.jooq.postgres.extensions.bindings.HstoreBinding;
import org.jooq.postgres.extensions.types.Hstore;

public class PostgresCommons {
    public static final Function<Date, LocalDateTime> DATE_TO_LOCAL_DATE_TIME = date -> Optional.ofNullable(date).map(value -> LocalDateTime.ofInstant(value.toInstant(), ZoneOffset.UTC)).orElse(null);
    public static final Function<ZonedDateTime, LocalDateTime> ZONED_DATE_TIME_TO_LOCAL_DATE_TIME = date -> Optional.ofNullable(date).map(value -> value.withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime()).orElse(null);
    public static final Function<Instant, LocalDateTime> INSTANT_TO_LOCAL_DATE_TIME = instant -> Optional.ofNullable(instant).map(value -> LocalDateTime.ofInstant(instant, ZoneOffset.UTC)).orElse(null);
    public static final Function<LocalDateTime, Date> LOCAL_DATE_TIME_DATE_FUNCTION = localDateTime -> Optional.ofNullable(localDateTime).map(value -> value.toInstant(ZoneOffset.UTC)).map(Date::from).orElse(null);
    public static final Function<LocalDateTime, ZonedDateTime> LOCAL_DATE_TIME_ZONED_DATE_TIME_FUNCTION = localDateTime -> Optional.ofNullable(localDateTime).map(value -> value.atZone(ZoneId.of("UTC"))).orElse(null);
    public static final Function<OffsetDateTime, ZonedDateTime> OFFSET_DATE_TIME_ZONED_DATE_TIME_FUNCTION = offsetDateTime -> Optional.ofNullable(offsetDateTime).map(value -> value.atZoneSameInstant(ZoneId.of("UTC"))).orElse(null);
    public static final Function<LocalDateTime, Instant> LOCAL_DATE_TIME_INSTANT_FUNCTION = localDateTime -> Optional.ofNullable(localDateTime).map(value -> value.toInstant(ZoneOffset.UTC)).orElse(null);
    public static final Function<Field<?>, Field<?>> UNNEST_FIELD = field -> DSL.function((String)"unnest", field.getType().getComponentType(), (Field[])new Field[]{field});
    public static final int IN_CLAUSE_MAX_SIZE = 32;

    public static <T> Field<T> tableField(Table<Record> table, Field<T> field) {
        return DSL.field((String)(table.getName() + "." + field.getName()), (DataType)field.getDataType());
    }

    public static interface DataTypes {
        public static final DataType<Hstore> HSTORE = DefaultDataType.getDefaultDataType((String)"hstore").asConvertedDataType((Binding)new HstoreBinding());
        public static final DataType<LocalDateTime> TIMESTAMP = SQLDataType.LOCALDATETIME((int)6);
        public static final DataType<OffsetDateTime> TIMESTAMP_WITH_TIMEZONE = SQLDataType.TIMESTAMPWITHTIMEZONE((int)6);
        public static final DataType<String[]> STRING_ARRAY = SQLDataType.VARCHAR.getArrayDataType();
    }
}

