/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;

public class QueueQueryResult {
    private QueueConfiguration config;
    private boolean exists;
    private int consumerCount;
    private long messageCount;
    private boolean autoCreateQueues;
    private Integer defaultConsumerWindowSize;

    public QueueQueryResult(QueueConfiguration config, int consumerCount, long messageCount, boolean autoCreateQueues, boolean exists, Integer defaultConsumerWindowSize) {
        this.config = config;
        this.consumerCount = consumerCount;
        this.messageCount = messageCount;
        this.autoCreateQueues = autoCreateQueues;
        this.exists = exists;
        this.defaultConsumerWindowSize = defaultConsumerWindowSize;
    }

    public boolean isExists() {
        return this.exists;
    }

    public boolean isDurable() {
        return this.config.isDurable();
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public SimpleString getFilterString() {
        return this.config.getFilterString();
    }

    public SimpleString getAddress() {
        return this.config.getAddress();
    }

    public SimpleString getName() {
        return this.config.getName();
    }

    public boolean isTemporary() {
        return this.config.isTemporary();
    }

    public boolean isAutoCreateQueues() {
        return this.autoCreateQueues;
    }

    public boolean isAutoCreated() {
        return this.config.isAutoCreated();
    }

    public boolean isPurgeOnNoConsumers() {
        return this.config.isPurgeOnNoConsumers();
    }

    public RoutingType getRoutingType() {
        return this.config.getRoutingType();
    }

    public int getMaxConsumers() {
        return this.config.getMaxConsumers();
    }

    public void setAddress(SimpleString address) {
        this.config.setAddress(address);
    }

    public Boolean isExclusive() {
        return this.config.isExclusive();
    }

    public Boolean isLastValue() {
        return this.config.isLastValue();
    }

    public SimpleString getLastValueKey() {
        return this.config.getLastValueKey();
    }

    public Boolean isNonDestructive() {
        return this.config.isNonDestructive();
    }

    public Integer getConsumersBeforeDispatch() {
        return this.config.getConsumersBeforeDispatch();
    }

    public Long getDelayBeforeDispatch() {
        return this.config.getDelayBeforeDispatch();
    }

    public Integer getDefaultConsumerWindowSize() {
        return this.defaultConsumerWindowSize;
    }

    public Boolean isGroupRebalance() {
        return this.config.isGroupRebalance();
    }

    public Boolean isGroupRebalancePauseDispatch() {
        return this.config.isGroupRebalancePauseDispatch();
    }

    public Integer getGroupBuckets() {
        return this.config.getGroupBuckets();
    }

    public SimpleString getGroupFirstKey() {
        return this.config.getGroupFirstKey();
    }

    public Boolean isAutoDelete() {
        return this.config.isAutoDelete();
    }

    public Long getAutoDeleteDelay() {
        return this.config.getAutoDeleteDelay();
    }

    public Long getAutoDeleteMessageCount() {
        return this.config.getAutoDeleteMessageCount();
    }

    public Long getRingSize() {
        return this.config.getRingSize();
    }

    public Boolean isEnabled() {
        return this.config.isEnabled();
    }

    public Boolean isConfigurationManaged() {
        return this.config.isConfigurationManaged();
    }
}

