/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.search;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.util.Optional;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraFirstUnseenDAO;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import reactor.core.publisher.Flux;

public class UnseenSearchOverride
implements ListeningMessageSearchIndex.SearchOverride {
    private final CassandraFirstUnseenDAO dao;

    @Inject
    public UnseenSearchOverride(CassandraFirstUnseenDAO dao) {
        this.dao = dao;
    }

    public boolean applicable(SearchQuery searchQuery, MailboxSession session) {
        return this.isUnseenWithAll(searchQuery) || this.isNotSeenWithAll(searchQuery);
    }

    private boolean isUnseenWithAll(SearchQuery searchQuery) {
        return searchQuery.getCriteria().contains(SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN)) && this.allMessages(searchQuery) && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    private boolean isNotSeenWithAll(SearchQuery searchQuery) {
        return searchQuery.getCriteria().contains(SearchQuery.not((SearchQuery.Criterion)SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN))) && this.allMessages(searchQuery) && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    private boolean allMessages(SearchQuery searchQuery) {
        if (searchQuery.getCriteria().size() == 1) {
            return true;
        }
        if (searchQuery.getCriteria().size() == 2) {
            return searchQuery.getCriteria().stream().anyMatch(criterion -> criterion instanceof SearchQuery.UidCriterion) || searchQuery.getCriteria().stream().anyMatch(criterion -> criterion instanceof SearchQuery.AllCriterion);
        }
        return false;
    }

    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        Optional<SearchQuery.UidCriterion> maybeUidCriterion = searchQuery.getCriteria().stream().filter(criterion -> criterion instanceof SearchQuery.UidCriterion).map(SearchQuery.UidCriterion.class::cast).findFirst();
        return maybeUidCriterion.map(uidCriterion -> Flux.fromIterable((Iterable)ImmutableList.copyOf((Object[])uidCriterion.getOperator().getRange())).concatMap(range -> this.dao.listUnseen((CassandraId)mailbox.getMailboxId(), MessageRange.range((MessageUid)range.getLowValue(), (MessageUid)range.getHighValue())))).orElseGet(() -> this.dao.listUnseen((CassandraId)mailbox.getMailboxId()));
    }
}

