/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.eventsourcing.EventId;

public class Version {
    public static final Version INITIAL = new Version(-1);
    private final int version;

    public static Version from(Optional<EventId> eventId) {
        return eventId.map(EventId::value).map(Version::new).orElse(INITIAL);
    }

    public Version(int version) {
        this.version = version;
    }

    public final boolean equals(Object o) {
        if (o instanceof Version) {
            Version that = (Version)o;
            return Objects.equals(this.version, that.version);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).toString();
    }

    public String asString() {
        return String.valueOf(this.version);
    }

    public int asInteger() {
        return this.version;
    }

    public Optional<EventId> asEventId() {
        if (this.version == -1) {
            return Optional.empty();
        }
        return Optional.of(EventId.apply((int)this.version));
    }
}

