/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongComparators;
import it.unimi.dsi.fastutil.longs.LongList;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.DayMonthYear;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.api.message.request.SearchOperation;
import org.apache.james.imap.api.message.request.SearchResultOption;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SearchResUtil;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.SearchRequest;
import org.apache.james.imap.message.response.ESearchResponse;
import org.apache.james.imap.message.response.SearchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageSequenceNumber;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SearchProcessor
extends AbstractMailboxProcessor<SearchRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchProcessor.class);
    protected static final String SEARCH_MODSEQ = "SEARCH_MODSEQ";
    private static final List<Capability> CAPS = ImmutableList.of((Object)Capability.of("WITHIN"), (Object)Capability.of("ESEARCH"), (Object)Capability.of("SEARCHRES"), (Object)Capability.of("PARTIAL"));
    public static final SearchQuery.Sort DEFAULT_IMAP_SORT = new SearchQuery.Sort(SearchQuery.Sort.SortClause.Uid, SearchQuery.Sort.Order.NATURAL);

    @Inject
    public SearchProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(SearchRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(SearchRequest request, ImapSession session, ImapProcessor.Responder responder) {
        SearchOperation operation = request.getSearchOperation();
        SearchKey searchKey = operation.getSearchKey();
        try {
            MailboxSession msession = session.getMailboxSession();
            SearchQuery query = this.toQuery(searchKey, session);
            boolean useUids = request.isUseUids();
            boolean omitExpunged = !useUids;
            return this.getSelectedMailboxReactive(session).flatMap((Function)Throwing.function(mailbox -> this.performUidSearch((MessageManager)mailbox, query, msession).flatMap(uids -> this.computeHighestModSeqIfNeeded(session, responder, (MessageManager)mailbox, msession, (Collection<MessageUid>)uids).doOnNext(highestModSeq -> {
                ImapResponseMessage response = this.toResponse(request, session, (Collection<MessageUid>)uids, (Optional<ModSeq>)highestModSeq);
                responder.respond(response);
            })).then(this.unsolicitedResponses(session, responder, omitExpunged, useUids)))).then(Mono.fromRunnable(() -> {
                this.okComplete(request, responder);
                session.setAttribute(SEARCH_MODSEQ, null);
            })).then().onErrorResume(MessageRangeException.class, e -> {
                this.no(request, responder, HumanReadableText.SEARCH_FAILED);
                if (request.getSearchOperation().getResultOptions().contains((Object)SearchResultOption.SAVE)) {
                    SearchResUtil.resetSavedSequenceSet(session);
                }
                return ReactorUtils.logAsMono(() -> LOGGER.error("Search failed in mailbox {}", (Object)session.getSelected().getMailboxId(), e));
            });
        }
        catch (MessageRangeException e2) {
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Search failed in mailbox {} because of an invalid sequence-set ", (Object)session.getSelected().getMailboxId(), (Object)e2)).then(Mono.fromRunnable(() -> this.taggedBad(request, responder, HumanReadableText.INVALID_MESSAGESET)));
        }
    }

    private Mono<Optional<ModSeq>> computeHighestModSeqIfNeeded(ImapSession session, ImapProcessor.Responder responder, MessageManager mailbox, MailboxSession msession, Collection<MessageUid> uids) {
        if (session.getAttribute(SEARCH_MODSEQ) != null) {
            try {
                return mailbox.getMetaDataReactive(MessageManager.MailboxMetaData.RecentMode.IGNORE, msession, EnumSet.of(MessageManager.MailboxMetaData.Item.HighestModSeq)).flatMap(metaData -> {
                    this.condstoreEnablingCommand(session, responder, (MessageManager.MailboxMetaData)metaData, true);
                    return this.findHighestModSeq(msession, mailbox, MessageRange.toRanges((Collection)uids), metaData.getHighestModSeq());
                }).switchIfEmpty(Mono.empty());
            }
            catch (MailboxException e) {
                throw new RuntimeException(e);
            }
        }
        return Mono.just(Optional.empty());
    }

    private ImapResponseMessage toResponse(SearchRequest request, ImapSession session, Collection<MessageUid> uids, Optional<ModSeq> highestModSeq) {
        LongList ids = this.asResults(session, request.isUseUids(), uids);
        List<SearchResultOption> resultOptions = request.getSearchOperation().getResultOptions();
        if (resultOptions == null || resultOptions.isEmpty()) {
            return new SearchResponse(ids, highestModSeq.orElse(null));
        }
        return this.handleResultOptions(request, session, highestModSeq.orElse(null), ids);
    }

    private ImapResponseMessage handleResultOptions(SearchRequest request, ImapSession session, ModSeq highestModSeq, LongList ids) {
        List<SearchResultOption> resultOptions = request.getSearchOperation().getResultOptions();
        IdRange[] idRanges = this.asRanges(request.getSearchOperation().getPartialRange().map(partialRange -> partialRange.filter(ids)).orElse(ids));
        boolean esearch = false;
        for (SearchResultOption resultOption : resultOptions) {
            if (SearchResultOption.SAVE == resultOption) continue;
            esearch = true;
            break;
        }
        if (esearch) {
            long min = -1L;
            long max = -1L;
            long count = ids.size();
            if (!ids.isEmpty()) {
                min = ids.getLong(0);
                max = ids.getLong(ids.size() - 1);
            }
            if (resultOptions.contains((Object)SearchResultOption.SAVE)) {
                if (resultOptions.contains((Object)SearchResultOption.ALL) || resultOptions.contains((Object)SearchResultOption.COUNT) || resultOptions.contains((Object)SearchResultOption.PARTIAL)) {
                    SearchResUtil.saveSequenceSet(session, idRanges);
                } else {
                    ArrayList<IdRange> savedRanges = new ArrayList<IdRange>();
                    if (resultOptions.contains((Object)SearchResultOption.MIN) && min > 0L) {
                        savedRanges.add(new IdRange(min));
                    }
                    if (resultOptions.contains((Object)SearchResultOption.MAX) && max > 0L) {
                        savedRanges.add(new IdRange(max));
                    }
                    SearchResUtil.saveSequenceSet(session, (IdRange[])savedRanges.toArray(IdRange[]::new));
                }
            }
            return new ESearchResponse(min, max, count, this.allRange(resultOptions, idRanges), this.partialRange(resultOptions, idRanges), highestModSeq, request.getTag(), request.isUseUids(), resultOptions, request.getSearchOperation().getPartialRange());
        }
        SearchResUtil.saveSequenceSet(session, idRanges);
        return new SearchResponse(ids, highestModSeq);
    }

    private IdRange[] allRange(List<SearchResultOption> resultOptions, IdRange[] idRanges) {
        if (resultOptions.contains((Object)SearchResultOption.PARTIAL)) {
            return null;
        }
        return idRanges;
    }

    private IdRange[] partialRange(List<SearchResultOption> resultOptions, IdRange[] idRanges) {
        if (resultOptions.contains((Object)SearchResultOption.PARTIAL)) {
            return idRanges;
        }
        return null;
    }

    private IdRange[] asRanges(LongList ids) {
        ids.sort(LongComparators.NATURAL_COMPARATOR);
        ArrayList<IdRange> idsAsRanges = new ArrayList<IdRange>();
        long lowBound = -1L;
        long highBound = -1L;
        for (int i = 0; i < ids.size(); ++i) {
            long id = ids.getLong(i);
            if (lowBound == -1L) {
                lowBound = id;
                highBound = id;
                continue;
            }
            if (id == highBound + 1L) {
                highBound = id;
                continue;
            }
            idsAsRanges.add(new IdRange(lowBound, highBound));
            lowBound = id;
            highBound = id;
        }
        if (lowBound != -1L && highBound != -1L) {
            idsAsRanges.add(new IdRange(lowBound, highBound));
        }
        IdRange[] result = new IdRange[idsAsRanges.size()];
        return idsAsRanges.toArray(result);
    }

    private LongList asResults(ImapSession session, boolean useUids, Collection<MessageUid> uids) {
        LongArrayList result = new LongArrayList(uids.size());
        if (useUids) {
            for (MessageUid uid : uids) {
                result.add(uid.asLong());
            }
        } else {
            for (MessageUid uid : uids) {
                session.getSelected().msn(uid).ifPresent(arg_0 -> SearchProcessor.lambda$asResults$11((LongList)result, arg_0));
            }
        }
        return result;
    }

    private Mono<Collection<MessageUid>> performUidSearch(MessageManager mailbox, SearchQuery query, MailboxSession msession) throws MailboxException {
        return Flux.from((Publisher)mailbox.search(query, msession)).collect(ImmutableList.toImmutableList());
    }

    private Mono<Optional<ModSeq>> findHighestModSeq(MailboxSession session, MessageManager mailbox, List<MessageRange> ranges, ModSeq currentHighest) {
        ArrayList<MessageRange> rangesCopy = new ArrayList<MessageRange>(ranges);
        Collections.reverse(rangesCopy);
        return Flux.fromIterable(rangesCopy).concatMap(range -> Flux.from((Publisher)mailbox.listMessagesMetadata(range, session))).map(ComposedMessageIdWithMetaData::getModSeq).takeUntil(modseq -> modseq.equals((Object)currentHighest)).reduce((a, b) -> {
            if (a.compareTo(b) > 0) {
                return a;
            }
            return b;
        }).map(Optional::of).switchIfEmpty(Mono.fromCallable(Optional::empty));
    }

    private SearchQuery toQuery(SearchKey key, ImapSession session) throws MessageRangeException {
        SearchQuery.Criterion criterion = this.toCriterion(key, session);
        SearchQuery.Builder builder = SearchQuery.builder();
        SelectedMailbox selected = session.getSelected();
        if (selected != null) {
            builder.addRecentMessageUids(selected.getRecent());
        }
        return builder.andCriterion(criterion).sorts(new SearchQuery.Sort[]{DEFAULT_IMAP_SORT}).build();
    }

    private SearchQuery.Criterion toCriterion(SearchKey key, ImapSession session) throws MessageRangeException {
        SearchKey.Type type = key.getType();
        DayMonthYear date = key.getDate();
        switch (type) {
            case TYPE_ALL: {
                return SearchQuery.all();
            }
            case TYPE_AND: {
                return this.and(key.getKeys(), session);
            }
            case TYPE_ANSWERED: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.ANSWERED);
            }
            case TYPE_BCC: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Bcc, (String)key.getValue());
            }
            case TYPE_BEFORE: {
                return SearchQuery.internalDateBefore((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case TYPE_BODY: {
                return SearchQuery.bodyContains((String)key.getValue());
            }
            case TYPE_CC: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Cc, (String)key.getValue());
            }
            case TYPE_DELETED: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DELETED);
            }
            case TYPE_DRAFT: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DRAFT);
            }
            case TYPE_FLAGGED: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.FLAGGED);
            }
            case TYPE_FROM: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.From, (String)key.getValue());
            }
            case TYPE_HEADER: {
                String value = key.getValue();
                if (value == null || value.length() == 0) {
                    return SearchQuery.headerExists((String)key.getName());
                }
                return SearchQuery.headerContains((String)key.getName(), (String)value);
            }
            case TYPE_KEYWORD: {
                return SearchQuery.flagIsSet((String)key.getValue());
            }
            case TYPE_LARGER: {
                return SearchQuery.sizeGreaterThan((long)key.getSize());
            }
            case TYPE_NEW: {
                return SearchQuery.and((SearchQuery.Criterion)SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.RECENT), (SearchQuery.Criterion)SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN));
            }
            case TYPE_NOT: {
                return this.not(key.getKeys(), session);
            }
            case TYPE_OLD: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.RECENT);
            }
            case TYPE_ON: {
                return SearchQuery.internalDateOn((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case TYPE_OR: {
                return this.or(key.getKeys(), session);
            }
            case TYPE_RECENT: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.RECENT);
            }
            case TYPE_SEEN: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN);
            }
            case TYPE_SENTBEFORE: {
                return SearchQuery.headerDateBefore((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case TYPE_SENTON: {
                return SearchQuery.headerDateOn((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case TYPE_SENTSINCE: {
                SearchQuery.Criterion onCrit = SearchQuery.headerDateOn((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
                SearchQuery.Criterion afterCrit = SearchQuery.headerDateAfter((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
                return SearchQuery.or((SearchQuery.Criterion)onCrit, (SearchQuery.Criterion)afterCrit);
            }
            case TYPE_SEQUENCE_SET: {
                return this.sequence(key.getSequenceNumbers(), session);
            }
            case TYPE_SINCE: {
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day), (SearchQuery.Criterion)SearchQuery.internalDateAfter((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
            }
            case TYPE_SMALLER: {
                return SearchQuery.sizeLessThan((long)key.getSize());
            }
            case TYPE_SUBJECT: {
                return SearchQuery.subject((String)key.getValue());
            }
            case TYPE_TEXT: {
                return SearchQuery.mailContains((String)key.getValue());
            }
            case TYPE_TO: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)key.getValue());
            }
            case TYPE_UID: {
                return this.uids(key.getUidRanges(), session);
            }
            case TYPE_UNANSWERED: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.ANSWERED);
            }
            case TYPE_UNDELETED: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DELETED);
            }
            case TYPE_UNDRAFT: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DRAFT);
            }
            case TYPE_UNFLAGGED: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.FLAGGED);
            }
            case TYPE_UNKEYWORD: {
                return SearchQuery.flagIsUnSet((String)key.getValue());
            }
            case TYPE_UNSEEN: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN);
            }
            case TYPE_OLDER: {
                Date withinDate = this.createWithinDate(key);
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)withinDate, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second), (SearchQuery.Criterion)SearchQuery.internalDateBefore((Date)withinDate, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second));
            }
            case TYPE_YOUNGER: {
                Date withinDate2 = this.createWithinDate(key);
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)withinDate2, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second), (SearchQuery.Criterion)SearchQuery.internalDateAfter((Date)withinDate2, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second));
            }
            case TYPE_MODSEQ: {
                session.setAttribute(SEARCH_MODSEQ, true);
                long modSeq = key.getModSeq();
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.modSeqEquals((long)modSeq), (SearchQuery.Criterion)SearchQuery.modSeqGreaterThan((long)modSeq));
            }
            case TYPE_THREADID: {
                return SearchQuery.threadId((ThreadId)ThreadId.fromBaseMessageId((MessageId)this.getMailboxManager().getMessageIdFactory().fromString(key.getThreadId())));
            }
            case TYPE_EMAILID: {
                return SearchQuery.hasMessageId((MessageId)this.getMailboxManager().getMessageIdFactory().fromString(key.getMessageId()));
            }
            case TYPE_SAVEDBEFORE: {
                return SearchQuery.saveDateBefore((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case TYPE_SAVEDON: {
                return SearchQuery.saveDateOn((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case TYPE_SAVEDSINCE: {
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.saveDateOn((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day), (SearchQuery.Criterion)SearchQuery.saveDateAfter((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
            }
            case TYPE_SAVEDATESUPPORTED: {
                return SearchQuery.saveDateSupported();
            }
        }
        LOGGER.warn("Ignoring unknown search key {}", (Object)type);
        return SearchQuery.all();
    }

    private Date createWithinDate(SearchKey key) {
        long seconds = key.getSeconds();
        long res = System.currentTimeMillis() - seconds * 1000L;
        return new Date(res);
    }

    private SearchQuery.Criterion sequence(IdRange[] sequenceNumbers, ImapSession session) throws MessageRangeException {
        SelectedMailbox selected = session.getSelected();
        ArrayList<SearchQuery.UidRange> ranges = new ArrayList<SearchQuery.UidRange>();
        if (selected.existsCount() > 0L) {
            for (IdRange range : sequenceNumbers) {
                long lowVal = range.getLowVal();
                long highVal = range.getHighVal();
                if (lowVal == Long.MAX_VALUE && highVal == Long.MAX_VALUE) {
                    MessageUid highUid = selected.getLastUid().orElse(MessageUid.MIN_VALUE);
                    ranges.add(new SearchQuery.UidRange(highUid));
                    continue;
                }
                Optional<MessageUid> lowUid = lowVal != Long.MIN_VALUE ? selected.uid((int)lowVal) : selected.getFirstUid();
                if (!lowUid.isPresent()) continue;
                Optional<Object> highUid = Optional.empty();
                if (highVal != Long.MAX_VALUE) {
                    highUid = selected.uid((int)highVal);
                    if (!highUid.isPresent()) {
                        highUid = selected.getLastUid();
                    }
                } else {
                    highUid = selected.getLastUid();
                }
                ranges.add(new SearchQuery.UidRange(lowUid.orElse(MessageUid.MIN_VALUE), (MessageUid)highUid.orElse(MessageUid.MAX_VALUE)));
            }
        }
        return SearchQuery.uid((SearchQuery.UidRange[])((SearchQuery.UidRange[])ranges.toArray(SearchQuery.UidRange[]::new)));
    }

    private SearchQuery.Criterion uids(UidRange[] uids, ImapSession session) throws MessageRangeException {
        SelectedMailbox selected = session.getSelected();
        ArrayList<SearchQuery.UidRange> ranges = new ArrayList<SearchQuery.UidRange>();
        if (selected.existsCount() > 0L) {
            for (UidRange range : uids) {
                MessageUid lowVal = range.getLowVal();
                MessageUid highVal = range.getHighVal();
                if (lowVal.equals((Object)MessageUid.MAX_VALUE) && highVal.equals((Object)MessageUid.MAX_VALUE)) {
                    ranges.add(new SearchQuery.UidRange(selected.getLastUid().orElse(MessageUid.MIN_VALUE)));
                    continue;
                }
                if (highVal.equals((Object)MessageUid.MAX_VALUE) && selected.getLastUid().orElse(MessageUid.MIN_VALUE).compareTo(lowVal) < 0) {
                    ranges.add(new SearchQuery.UidRange(selected.getLastUid().orElse(MessageUid.MIN_VALUE)));
                    continue;
                }
                ranges.add(new SearchQuery.UidRange(lowVal, highVal));
            }
        }
        return SearchQuery.uid((SearchQuery.UidRange[])((SearchQuery.UidRange[])ranges.toArray(SearchQuery.UidRange[]::new)));
    }

    private SearchQuery.Criterion or(List<SearchKey> keys, ImapSession session) throws MessageRangeException {
        SearchKey keyOne = keys.get(0);
        SearchKey keyTwo = keys.get(1);
        SearchQuery.Criterion criterionOne = this.toCriterion(keyOne, session);
        SearchQuery.Criterion criterionTwo = this.toCriterion(keyTwo, session);
        return SearchQuery.or((SearchQuery.Criterion)criterionOne, (SearchQuery.Criterion)criterionTwo);
    }

    private SearchQuery.Criterion not(List<SearchKey> keys, ImapSession session) throws MessageRangeException {
        SearchKey key = keys.get(0);
        SearchQuery.Criterion criterion = this.toCriterion(key, session);
        return SearchQuery.not((SearchQuery.Criterion)criterion);
    }

    private SearchQuery.Criterion and(List<SearchKey> keys, ImapSession session) throws MessageRangeException {
        int size = keys.size();
        ArrayList<SearchQuery.Criterion> criteria = new ArrayList<SearchQuery.Criterion>(size);
        for (SearchKey key : keys) {
            SearchQuery.Criterion criterion = this.toCriterion(key, session);
            criteria.add(criterion);
        }
        return SearchQuery.and(criteria);
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected MDCBuilder mdc(SearchRequest request) {
        return MDCBuilder.create().addToContext("action", "SEARCH").addToContext("useUid", Boolean.toString(request.isUseUids())).addToContext("searchOperation", request.getSearchOperation().toString());
    }

    private static /* synthetic */ void lambda$asResults$11(LongList result, MessageSequenceNumber l) {
        result.add((long)l.asInt());
    }
}

