/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra.model;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.ScriptSummary;

public class Script {
    private final ScriptName name;
    private final ScriptContent content;
    private final boolean isActive;
    private final long size;

    public static Builder builder() {
        return new Builder();
    }

    private Script(ScriptName name, ScriptContent content, boolean isActive, long size) {
        this.name = name;
        this.content = content;
        this.isActive = isActive;
        this.size = size;
    }

    public ScriptName getName() {
        return this.name;
    }

    public ScriptContent getContent() {
        return this.content;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public ScriptSummary toSummary() {
        return new ScriptSummary(this.name, this.isActive, this.size);
    }

    public long getSize() {
        return this.size;
    }

    public final boolean equals(Object o) {
        if (o instanceof Script) {
            Script that = (Script)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.content, that.content) && Objects.equals(this.isActive, that.isActive) && Objects.equals(this.size, that.size);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.content, this.isActive, this.size);
    }

    public static class Builder {
        private ScriptName name;
        private ScriptContent content;
        private Optional<Boolean> isActive = Optional.empty();
        private Optional<Long> size = Optional.empty();

        public Builder name(ScriptName name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            return this.name(new ScriptName(name));
        }

        public Builder copyOf(Script script) {
            this.name = script.getName();
            this.content = script.getContent();
            this.isActive = Optional.of(script.isActive());
            this.size = Optional.of(script.getSize());
            return this;
        }

        public Builder content(ScriptContent content) {
            this.content = content;
            return this;
        }

        public Builder content(String content) {
            return this.content(new ScriptContent(content));
        }

        public Builder size(long size) {
            this.size = Optional.of(size);
            return this;
        }

        public Builder isActive(boolean isActive) {
            this.isActive = Optional.of(isActive);
            return this;
        }

        public Script build() {
            Preconditions.checkState((this.name != null ? 1 : 0) != 0);
            Preconditions.checkState((this.content != null ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.isActive.isPresent());
            return new Script(this.name, this.content, this.isActive.get(), this.size.orElse(Long.valueOf(this.content.length())));
        }
    }
}

