/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Domain;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.cassandra.tables.CassandraDomainsTable;
import org.apache.james.domainlist.lib.AbstractDomainList;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;

public class CassandraDomainList
extends AbstractDomainList {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement readAllStatement;
    private final PreparedStatement readStatement;
    private final PreparedStatement insertStatement;
    private final PreparedStatement removeStatement;

    @Inject
    public CassandraDomainList(DNSService dnsService, CqlSession session) {
        super(dnsService);
        this.executor = new CassandraAsyncExecutor(session);
        this.readAllStatement = session.prepare(QueryBuilder.selectFrom((String)"domains").column(CassandraDomainsTable.DOMAIN).build());
        this.readStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"domains").column(CassandraDomainsTable.DOMAIN).whereColumn(CassandraDomainsTable.DOMAIN).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDomainsTable.DOMAIN))).build());
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)"domains").value(CassandraDomainsTable.DOMAIN, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDomainsTable.DOMAIN)).ifNotExists().build());
        this.removeStatement = session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"domains").whereColumn(CassandraDomainsTable.DOMAIN).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDomainsTable.DOMAIN))).ifExists()).build());
    }

    protected List<Domain> getDomainListInternal() throws DomainListException {
        return (List)this.executor.executeRows((Statement)this.readAllStatement.bind(new Object[0])).map(row -> Domain.of((String)((String)row.get(0, TypeCodecs.TEXT)))).collectList().block();
    }

    protected boolean containsDomainInternal(Domain domain) throws DomainListException {
        return ((Optional)this.executor.executeSingleRowOptional((Statement)this.readStatement.bind(new Object[0]).set(CassandraDomainsTable.DOMAIN, (Object)domain.asString(), TypeCodecs.TEXT)).block()).isPresent();
    }

    public Mono<Boolean> containsDomainReactive(Domain domain) {
        return this.executor.executeSingleRowOptional((Statement)this.readStatement.bind(new Object[0]).set(CassandraDomainsTable.DOMAIN, (Object)domain.asString(), TypeCodecs.TEXT)).handle(ReactorUtils.publishIfPresent()).hasElement();
    }

    public void addDomain(Domain domain) throws DomainListException {
        boolean executed = (Boolean)this.executor.executeReturnApplied((Statement)this.insertStatement.bind(new Object[0]).set(CassandraDomainsTable.DOMAIN, (Object)domain.asString(), TypeCodecs.TEXT)).block();
        if (!executed) {
            throw new DomainListException(domain.name() + " already exists.");
        }
    }

    public void doRemoveDomain(Domain domain) throws DomainListException {
        boolean executed = (Boolean)this.executor.executeReturnApplied((Statement)this.removeStatement.bind(new Object[0]).set(CassandraDomainsTable.DOMAIN, (Object)domain.asString(), TypeCodecs.TEXT)).block();
        if (!executed) {
            throw new DomainListException(domain.name() + " was not found");
        }
    }
}

