/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.service.ReprocessingService;

public class ReprocessingAllMailsTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"reprocessing-all");
    private final ReprocessingService reprocessingService;
    private final MailRepositoryPath repositoryPath;
    private final ReprocessingService.Configuration configuration;
    private final long repositorySize;
    private final AtomicLong processedCount;

    public ReprocessingAllMailsTask(ReprocessingService reprocessingService, long repositorySize, MailRepositoryPath repositoryPath, ReprocessingService.Configuration configuration) {
        this.reprocessingService = reprocessingService;
        this.repositoryPath = repositoryPath;
        this.configuration = configuration;
        this.repositorySize = repositorySize;
        this.processedCount = new AtomicLong(0L);
    }

    private void notifyProgress(MailKey key) {
        this.processedCount.incrementAndGet();
    }

    public Task.Result run() {
        return (Task.Result)this.reprocessingService.reprocessAll(this.repositoryPath, this.configuration, this::notifyProgress).block();
    }

    MailRepositoryPath getRepositoryPath() {
        return this.repositoryPath;
    }

    long getRepositorySize() {
        return this.repositorySize;
    }

    ReprocessingService.Configuration getConfiguration() {
        return this.configuration;
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.repositoryPath, this.configuration, this.repositorySize, this.repositorySize - this.processedCount.get(), Clock.systemUTC().instant()));
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailRepositoryPath repositoryPath;
        private final ReprocessingService.Configuration configuration;
        private final long initialCount;
        private final long remainingCount;
        private final Instant timestamp;

        public AdditionalInformation(MailRepositoryPath repositoryPath, ReprocessingService.Configuration configuration, long initialCount, long remainingCount, Instant timestamp) {
            this.repositoryPath = repositoryPath;
            this.configuration = configuration;
            this.initialCount = initialCount;
            this.remainingCount = remainingCount;
            this.timestamp = timestamp;
        }

        public ReprocessingService.Configuration getConfiguration() {
            return this.configuration;
        }

        public String getRepositoryPath() {
            return this.repositoryPath.asString();
        }

        public long getRemainingCount() {
            return this.remainingCount;
        }

        public long getInitialCount() {
            return this.initialCount;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    public static class InvalidMailRepositoryPathDeserializationException
    extends RuntimeException {
        public InvalidMailRepositoryPathDeserializationException(String mailRepositoryPath) {
            super("Unable to deserialize: '" + mailRepositoryPath + "' can not be url decoded");
        }
    }

    public static class UrlEncodingFailureSerializationException
    extends RuntimeException {
        public UrlEncodingFailureSerializationException(MailRepositoryPath mailRepositoryPath) {
            super("Unable to serialize: '" + String.valueOf(mailRepositoryPath) + "' can not be url encoded");
        }
    }
}

