/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.ConnectionFunction;
import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.authentication.AuthenticationHandler;
import io.r2dbc.postgresql.authentication.PasswordAuthenticationHandler;
import io.r2dbc.postgresql.authentication.SASLAuthenticationHandler;
import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.client.ConnectionSettings;
import io.r2dbc.postgresql.client.PostgresStartupParameterProvider;
import io.r2dbc.postgresql.client.StartupMessageFlow;
import io.r2dbc.postgresql.message.backend.AuthenticationMessage;
import io.r2dbc.postgresql.util.Assert;
import java.net.SocketAddress;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

final class SingleHostConnectionFunction
implements ConnectionFunction {
    private final ConnectionFunction upstreamFunction;
    private final PostgresqlConnectionConfiguration configuration;

    SingleHostConnectionFunction(ConnectionFunction upstreamFunction, PostgresqlConnectionConfiguration configuration) {
        this.upstreamFunction = upstreamFunction;
        this.configuration = configuration;
    }

    @Override
    public Mono<Client> connect(SocketAddress endpoint, ConnectionSettings settings) {
        return this.upstreamFunction.connect(endpoint, settings).delayUntil(client -> this.getCredentials().flatMapMany(credentials -> StartupMessageFlow.exchange(auth -> this.getAuthenticationHandler((AuthenticationMessage)auth, (UsernameAndPassword)credentials), client, this.configuration.getDatabase(), credentials.getUsername(), SingleHostConnectionFunction.getParameterProvider(this.configuration, settings))).handle(ExceptionFactory.INSTANCE::handleErrorResponse));
    }

    private static PostgresStartupParameterProvider getParameterProvider(PostgresqlConnectionConfiguration configuration, ConnectionSettings settings) {
        return new PostgresStartupParameterProvider(configuration.getApplicationName(), configuration.getTimeZone(), settings);
    }

    protected AuthenticationHandler getAuthenticationHandler(AuthenticationMessage message, UsernameAndPassword usernameAndPassword) {
        if (PasswordAuthenticationHandler.supports(message)) {
            CharSequence password = Assert.requireNonNull(usernameAndPassword.getPassword(), "Password must not be null");
            return new PasswordAuthenticationHandler(password, usernameAndPassword.getUsername());
        }
        if (SASLAuthenticationHandler.supports(message)) {
            CharSequence password = Assert.requireNonNull(usernameAndPassword.getPassword(), "Password must not be null");
            return new SASLAuthenticationHandler(password, usernameAndPassword.getUsername());
        }
        throw new IllegalStateException(String.format("Unable to provide AuthenticationHandler capable of handling %s", message));
    }

    Mono<UsernameAndPassword> getCredentials() {
        return Mono.zip((Mono)Mono.from(this.configuration.getUsername()).single(), (Mono)Mono.from(this.configuration.getPassword()).singleOptional()).map(it -> new UsernameAndPassword((String)it.getT1(), ((Optional)it.getT2()).orElse(null)));
    }

    static class UsernameAndPassword {
        final String username;
        @Nullable
        final CharSequence password;

        public UsernameAndPassword(String username, @Nullable CharSequence password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        @Nullable
        public CharSequence getPassword() {
            return this.password;
        }
    }
}

