/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.byteunits;

import com.jakewharton.byteunits.ByteUnit;
import com.jakewharton.byteunits.UnitUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public enum DecimalByteUnit implements ByteUnit
{
    BYTES{

        @Override
        public long convert(long sourceCount, DecimalByteUnit sourceUnit) {
            return sourceUnit.toBytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return count;
        }

        @Override
        public long toKilobytes(long count) {
            return count / 1000L;
        }

        @Override
        public long toMegabytes(long count) {
            return count / 1000000L;
        }

        @Override
        public long toGigabytes(long count) {
            return count / 1000000000L;
        }

        @Override
        public long toTerabytes(long count) {
            return count / 1000000000000L;
        }

        @Override
        public long toPetabytes(long count) {
            return count / 1000000000000000L;
        }
    }
    ,
    KILOBYTES{

        @Override
        public long convert(long sourceCount, DecimalByteUnit sourceUnit) {
            return sourceUnit.toKilobytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return UnitUtil.multiply(count, 1000L, 9223372036854775L);
        }

        @Override
        public long toKilobytes(long count) {
            return count;
        }

        @Override
        public long toMegabytes(long count) {
            return count / 1000L;
        }

        @Override
        public long toGigabytes(long count) {
            return count / 1000000L;
        }

        @Override
        public long toTerabytes(long count) {
            return count / 1000000000L;
        }

        @Override
        public long toPetabytes(long count) {
            return count / 1000000000000L;
        }
    }
    ,
    MEGABYTES{

        @Override
        public long convert(long sourceCount, DecimalByteUnit sourceUnit) {
            return sourceUnit.toMegabytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return UnitUtil.multiply(count, 1000000L, 9223372036854L);
        }

        @Override
        public long toKilobytes(long count) {
            return UnitUtil.multiply(count, 1000L, 9223372036854775L);
        }

        @Override
        public long toMegabytes(long count) {
            return count;
        }

        @Override
        public long toGigabytes(long count) {
            return count / 1000L;
        }

        @Override
        public long toTerabytes(long count) {
            return count / 1000000L;
        }

        @Override
        public long toPetabytes(long count) {
            return count / 1000000000L;
        }
    }
    ,
    GIGABYTES{

        @Override
        public long convert(long sourceCount, DecimalByteUnit sourceUnit) {
            return sourceUnit.toGigabytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return UnitUtil.multiply(count, 1000000000L, 9223372036L);
        }

        @Override
        public long toKilobytes(long count) {
            return UnitUtil.multiply(count, 1000000L, 9223372036854L);
        }

        @Override
        public long toMegabytes(long count) {
            return UnitUtil.multiply(count, 1000L, 9223372036854775L);
        }

        @Override
        public long toGigabytes(long count) {
            return count;
        }

        @Override
        public long toTerabytes(long count) {
            return count / 1000L;
        }

        @Override
        public long toPetabytes(long count) {
            return count / 1000000L;
        }
    }
    ,
    TERABYTES{

        @Override
        public long convert(long sourceCount, DecimalByteUnit sourceUnit) {
            return sourceUnit.toTerabytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return UnitUtil.multiply(count, 1000000000000L, 0x8CBCCCL);
        }

        @Override
        public long toKilobytes(long count) {
            return UnitUtil.multiply(count, 1000000000L, 9223372036L);
        }

        @Override
        public long toMegabytes(long count) {
            return UnitUtil.multiply(count, 1000000L, 9223372036854L);
        }

        @Override
        public long toGigabytes(long count) {
            return UnitUtil.multiply(count, 1000L, 9223372036854775L);
        }

        @Override
        public long toTerabytes(long count) {
            return count;
        }

        @Override
        public long toPetabytes(long count) {
            return count / 1000L;
        }
    }
    ,
    PETABYTES{

        @Override
        public long convert(long sourceCount, DecimalByteUnit sourceUnit) {
            return sourceUnit.toPetabytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return UnitUtil.multiply(count, 1000000000000000L, 9223L);
        }

        @Override
        public long toKilobytes(long count) {
            return UnitUtil.multiply(count, 1000000000000L, 0x8CBCCCL);
        }

        @Override
        public long toMegabytes(long count) {
            return UnitUtil.multiply(count, 1000000000L, 9223372036L);
        }

        @Override
        public long toGigabytes(long count) {
            return UnitUtil.multiply(count, 1000000L, 9223372036854L);
        }

        @Override
        public long toTerabytes(long count) {
            return UnitUtil.multiply(count, 1000L, 9223372036854775L);
        }

        @Override
        public long toPetabytes(long count) {
            return count;
        }
    };

    private static final long B = 1L;
    private static final long KB = 1000L;
    private static final long MB = 1000000L;
    private static final long GB = 1000000000L;
    private static final long TB = 1000000000000L;
    private static final long PB = 1000000000000000L;
    private static final long MAX = Long.MAX_VALUE;
    private static final String[] UNITS;

    public long convert(long sourceCount, DecimalByteUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public long toKilobytes(long count) {
        throw new AbstractMethodError();
    }

    public long toMegabytes(long count) {
        throw new AbstractMethodError();
    }

    public long toGigabytes(long count) {
        throw new AbstractMethodError();
    }

    public long toTerabytes(long count) {
        throw new AbstractMethodError();
    }

    public long toPetabytes(long count) {
        throw new AbstractMethodError();
    }

    public static String format(long bytes) {
        return DecimalByteUnit.format(bytes, new DecimalFormat("#,##0.#"));
    }

    public static String format(long bytes, String pattern) {
        return DecimalByteUnit.format(bytes, new DecimalFormat(pattern));
    }

    public static String format(long bytes, NumberFormat format) {
        double count;
        if (bytes < 0L) {
            throw new IllegalArgumentException("bytes < 0: " + bytes);
        }
        int unitIndex = 0;
        for (count = (double)bytes; count >= 1000.0 && unitIndex < UNITS.length - 1; count /= 1000.0, ++unitIndex) {
        }
        return format.format(count) + ' ' + UNITS[unitIndex];
    }

    static {
        UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
    }
}

