/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.postgres.extensions.types;

import org.jooq.exception.DataTypeException;
import org.jooq.postgres.extensions.types.AbstractDiscreteRange;

public final class LongRange
extends AbstractDiscreteRange<Long, LongRange> {
    private LongRange(Long lower, boolean lowerIncluding, Long upper, boolean upperIncluding) {
        super(lower, lowerIncluding, upper, upperIncluding);
    }

    public static final LongRange longRange(Long lower, Long upper) {
        return new LongRange(lower, true, upper, false);
    }

    public static final LongRange longRange(Long lower, boolean lowerIncluding, Long upper, boolean upperIncluding) {
        return new LongRange(lower, lowerIncluding, upper, upperIncluding);
    }

    @Override
    final LongRange construct(Long lower, Long upper) {
        return new LongRange(lower, true, upper, false);
    }

    @Override
    final Long next(Long t) {
        long l = t;
        if (l == Long.MAX_VALUE) {
            throw new DataTypeException("Long overflow: " + String.valueOf(this));
        }
        return l + 1L;
    }

    @Override
    final Long prev(Long t) {
        long l = t;
        if (l == Long.MIN_VALUE) {
            throw new DataTypeException("Long underflow: " + String.valueOf(this));
        }
        return l - 1L;
    }
}

