/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.upload;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.postgres.upload.PostgresUploadDataDefinition;
import org.apache.james.mailbox.model.ContentType;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresUploadDAO {
    private final PostgresExecutor postgresExecutor;
    private final BlobId.Factory blobIdFactory;

    @Singleton
    @Inject
    public PostgresUploadDAO(@Named(value="by_pass_rls") PostgresExecutor postgresExecutor, BlobId.Factory blobIdFactory) {
        this.postgresExecutor = postgresExecutor;
        this.blobIdFactory = blobIdFactory;
    }

    public Mono<UploadMetaData> insert(UploadMetaData upload, Username user) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresUploadDataDefinition.PostgresUploadTable.TABLE_NAME).set(PostgresUploadDataDefinition.PostgresUploadTable.ID, (Object)upload.uploadId().getId()).set(PostgresUploadDataDefinition.PostgresUploadTable.CONTENT_TYPE, (Object)upload.contentType().asString()).set(PostgresUploadDataDefinition.PostgresUploadTable.SIZE, (Object)upload.sizeAsLong()).set(PostgresUploadDataDefinition.PostgresUploadTable.BLOB_ID, (Object)upload.blobId().asString()).set(PostgresUploadDataDefinition.PostgresUploadTable.USER_NAME, (Object)user.asString()).set(PostgresUploadDataDefinition.PostgresUploadTable.UPLOAD_DATE, (Object)((LocalDateTime)PostgresCommons.INSTANT_TO_LOCAL_DATE_TIME.apply(upload.uploadDate()))).returning(new SelectFieldOrAsterisk[]{PostgresUploadDataDefinition.PostgresUploadTable.ID, PostgresUploadDataDefinition.PostgresUploadTable.CONTENT_TYPE, PostgresUploadDataDefinition.PostgresUploadTable.SIZE, PostgresUploadDataDefinition.PostgresUploadTable.BLOB_ID, PostgresUploadDataDefinition.PostgresUploadTable.UPLOAD_DATE, PostgresUploadDataDefinition.PostgresUploadTable.USER_NAME}))).map(this::uploadMetaDataFromRow);
    }

    public Flux<UploadMetaData> list(Username user) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresUploadDataDefinition.PostgresUploadTable.TABLE_NAME).where(PostgresUploadDataDefinition.PostgresUploadTable.USER_NAME.eq((Object)user.asString())))).map(this::uploadMetaDataFromRow);
    }

    public Mono<UploadMetaData> get(UploadId uploadId, Username user) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.selectFrom(PostgresUploadDataDefinition.PostgresUploadTable.TABLE_NAME).where(PostgresUploadDataDefinition.PostgresUploadTable.ID.eq((Object)uploadId.getId())).and(PostgresUploadDataDefinition.PostgresUploadTable.USER_NAME.eq((Object)user.asString())))).map(this::uploadMetaDataFromRow);
    }

    public Mono<Boolean> delete(UploadId uploadId, Username user) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresUploadDataDefinition.PostgresUploadTable.TABLE_NAME).where(PostgresUploadDataDefinition.PostgresUploadTable.ID.eq((Object)uploadId.getId())).and(PostgresUploadDataDefinition.PostgresUploadTable.USER_NAME.eq((Object)user.asString())).returning(new SelectFieldOrAsterisk[]{PostgresUploadDataDefinition.PostgresUploadTable.ID}))).hasElement();
    }

    public Flux<Pair<UploadMetaData, Username>> listByUploadDateBefore(LocalDateTime before) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresUploadDataDefinition.PostgresUploadTable.TABLE_NAME).where(PostgresUploadDataDefinition.PostgresUploadTable.UPLOAD_DATE.lessThan((Object)before)))).map(record -> Pair.of((Object)this.uploadMetaDataFromRow((Record)record), (Object)Username.of((String)((String)record.get(PostgresUploadDataDefinition.PostgresUploadTable.USER_NAME)))));
    }

    private UploadMetaData uploadMetaDataFromRow(Record record) {
        return UploadMetaData.from((UploadId)UploadId.from((UUID)((UUID)record.get(PostgresUploadDataDefinition.PostgresUploadTable.ID))), (ContentType)Optional.ofNullable((String)record.get(PostgresUploadDataDefinition.PostgresUploadTable.CONTENT_TYPE)).map(ContentType::of).orElse(null), (long)((Long)record.get(PostgresUploadDataDefinition.PostgresUploadTable.SIZE)), (BlobId)this.blobIdFactory.parse((String)record.get(PostgresUploadDataDefinition.PostgresUploadTable.BLOB_ID)), (Instant)((Instant)PostgresCommons.LOCAL_DATE_TIME_INSTANT_FUNCTION.apply((LocalDateTime)record.get(PostgresUploadDataDefinition.PostgresUploadTable.UPLOAD_DATE, LocalDateTime.class))));
    }

    public static class Factory {
        private final BlobId.Factory blobIdFactory;
        private final PostgresExecutor.Factory executorFactory;

        @Inject
        @Singleton
        public Factory(BlobId.Factory blobIdFactory, PostgresExecutor.Factory executorFactory) {
            this.blobIdFactory = blobIdFactory;
            this.executorFactory = executorFactory;
        }

        public PostgresUploadDAO create(Optional<Domain> domain) {
            return new PostgresUploadDAO(this.executorFactory.create(domain), this.blobIdFactory);
        }
    }
}

