/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.other;

import com.github.f4b6a3.uuid.codec.StandardBinaryCodec;
import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.codec.base.Base32Codec;
import com.github.f4b6a3.uuid.codec.base.Base64UrlCodec;
import com.github.f4b6a3.uuid.codec.base.BaseNCodec;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.UuidValidator;
import com.github.f4b6a3.uuid.util.immutable.ByteArray;
import com.github.f4b6a3.uuid.util.immutable.CharArray;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.util.Arrays;
import java.util.UUID;

public final class NcnameCodec
implements UuidCodec<String> {
    public static final NcnameCodec INSTANCE = new NcnameCodec();
    private final int radix;
    private final int length;
    private final int shift;
    private final char padding;
    private final BaseNCodec codec;
    private static final CharArray VERSION_UPPERCASE = CharArray.from("ABCDEFGHIJKLMNOP".toCharArray());
    private static final CharArray VERSION_LOWERCASE = CharArray.from("abcdefghijklmnop".toCharArray());
    private static final ByteArray VERSION_MAP;

    public NcnameCodec() {
        this(Base64UrlCodec.INSTANCE);
    }

    public NcnameCodec(BaseNCodec codec) {
        if (!(codec instanceof Base64UrlCodec) && !(codec instanceof Base32Codec)) {
            throw new IllegalArgumentException("Unsupported base-n codec");
        }
        this.codec = codec;
        this.radix = codec.getBase().getRadix();
        this.length = codec.getBase().getLength();
        this.padding = codec.getBase().getPadding();
        switch (this.radix) {
            case 32: {
                this.shift = 1;
                break;
            }
            case 64: {
                this.shift = 2;
                break;
            }
            default: {
                this.shift = 0;
            }
        }
    }

    @Override
    public String encode(UUID uuid) {
        UuidValidator.validate(uuid);
        int version = uuid.version();
        byte[] bytes = StandardBinaryCodec.INSTANCE.encode(uuid);
        int[] ints = ByteUtil.toInts(bytes);
        int variant = (ints[2] & 0xF0000000) >>> 24;
        ints[1] = ints[1] & 0xFFFF0000 | (ints[1] & 0xFFF) << 4 | (ints[2] & 0xFFFFFFF) >>> 24;
        ints[2] = (ints[2] & 0xFFFFFF) << 8 | ints[3] >>> 24;
        ints[3] = ints[3] << 8 | variant;
        bytes = ByteUtil.fromInts(ints);
        bytes[15] = (byte)((bytes[15] & 0xFF) >>> this.shift);
        UUID uuuu = StandardBinaryCodec.INSTANCE.decode(bytes);
        String encoded = this.codec.encode(uuuu).substring(0, this.length - 1);
        char v = this.radix == 64 ? VERSION_UPPERCASE.get(version) : VERSION_LOWERCASE.get(version);
        return v + encoded;
    }

    @Override
    public UUID decode(String ncname) {
        if (ncname == null || ncname.length() != this.length) {
            throw new InvalidUuidException("Invalid UUID NCName: \"" + ncname + "\"");
        }
        byte bookend1 = VERSION_MAP.get(ncname.charAt(0));
        byte bookend2 = VERSION_MAP.get(ncname.charAt(ncname.length() - 1));
        if (bookend1 == -1 || bookend2 == -1) {
            throw new InvalidUuidException("Invalid UUID NCName: \"" + ncname + "\"");
        }
        int version = bookend1 & 0xF;
        String substring = ncname.substring(1, ncname.length());
        UUID uuid = this.codec.decode(substring + this.padding);
        byte[] bytes = StandardBinaryCodec.INSTANCE.encode(uuid);
        bytes[15] = (byte)((bytes[15] & 0xFF) << this.shift);
        int[] ints = ByteUtil.toInts(bytes);
        int variant = (ints[3] & 0xF0) << 24;
        ints[3] = ints[3] >>> 8;
        ints[3] = ints[3] | (ints[2] & 0xFF) << 24;
        ints[2] = ints[2] >>> 8;
        ints[2] = ints[2] | ((ints[1] & 0xF) << 24 | variant);
        ints[1] = ints[1] & 0xFFFF0000 | version << 12 | ints[1] >>> 4 & 0xFFF;
        bytes = ByteUtil.fromInts(ints);
        return StandardBinaryCodec.INSTANCE.decode(bytes);
    }

    static {
        byte[] mapping = new byte[256];
        Arrays.fill(mapping, (byte)-1);
        mapping[65] = 0;
        mapping[66] = 1;
        mapping[67] = 2;
        mapping[68] = 3;
        mapping[69] = 4;
        mapping[70] = 5;
        mapping[71] = 6;
        mapping[72] = 7;
        mapping[73] = 8;
        mapping[74] = 9;
        mapping[75] = 10;
        mapping[76] = 11;
        mapping[77] = 12;
        mapping[78] = 13;
        mapping[79] = 14;
        mapping[80] = 15;
        mapping[97] = 0;
        mapping[98] = 1;
        mapping[99] = 2;
        mapping[100] = 3;
        mapping[101] = 4;
        mapping[102] = 5;
        mapping[103] = 6;
        mapping[104] = 7;
        mapping[105] = 8;
        mapping[106] = 9;
        mapping[107] = 10;
        mapping[108] = 11;
        mapping[109] = 12;
        mapping[110] = 13;
        mapping[111] = 14;
        mapping[112] = 15;
        VERSION_MAP = ByteArray.from(mapping);
    }
}

