/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.tasks;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.opensearch.tasks.TaskExecutingNode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class CancelResponse
implements PlainJsonSerializable {
    private final List<ErrorCause> nodeFailures;
    private final Map<String, TaskExecutingNode> nodes;
    public static final JsonpDeserializer<CancelResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CancelResponse::setupCancelResponseDeserializer);

    private CancelResponse(Builder builder) {
        this.nodeFailures = ApiTypeHelper.unmodifiable(builder.nodeFailures);
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
    }

    public static CancelResponse of(Function<Builder, ObjectBuilder<CancelResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ErrorCause> nodeFailures() {
        return this.nodeFailures;
    }

    public final Map<String, TaskExecutingNode> nodes() {
        return this.nodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.nodeFailures)) {
            generator.writeKey("node_failures");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.nodeFailures) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry entry : this.nodes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((TaskExecutingNode)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCancelResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeFailures, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "node_failures");
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(TaskExecutingNode._DESERIALIZER), "nodes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CancelResponse> {
        @Nullable
        private List<ErrorCause> nodeFailures;
        private Map<String, TaskExecutingNode> nodes;

        public final Builder nodeFailures(List<ErrorCause> list) {
            this.nodeFailures = Builder._listAddAll(this.nodeFailures, list);
            return this;
        }

        public final Builder nodeFailures(ErrorCause value, ErrorCause ... values) {
            this.nodeFailures = Builder._listAdd(this.nodeFailures, value, values);
            return this;
        }

        public final Builder nodeFailures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.nodeFailures(fn.apply(new ErrorCause.Builder()).build(), new ErrorCause[0]);
        }

        public final Builder nodes(Map<String, TaskExecutingNode> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        public final Builder nodes(String key, TaskExecutingNode value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        public final Builder nodes(String key, Function<TaskExecutingNode.Builder, ObjectBuilder<TaskExecutingNode>> fn) {
            return this.nodes(key, fn.apply(new TaskExecutingNode.Builder()).build());
        }

        @Override
        public CancelResponse build() {
            this._checkSingleUse();
            return new CancelResponse(this);
        }
    }
}

