/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ml.ColumnMeta;
import org.opensearch.client.opensearch.ml.Rows;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PredictionResult
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PredictionResult> {
    @Nonnull
    private final List<ColumnMeta> columnMetas;
    @Nonnull
    private final List<Rows> rows;
    public static final JsonpDeserializer<PredictionResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PredictionResult::setupPredictionResultDeserializer);

    private PredictionResult(Builder builder) {
        this.columnMetas = ApiTypeHelper.unmodifiable(builder.columnMetas);
        this.rows = ApiTypeHelper.unmodifiable(builder.rows);
    }

    public static PredictionResult of(Function<Builder, ObjectBuilder<PredictionResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<ColumnMeta> columnMetas() {
        return this.columnMetas;
    }

    @Nonnull
    public final List<Rows> rows() {
        return this.rows;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.columnMetas)) {
            generator.writeKey("column_metas");
            generator.writeStartArray();
            for (ColumnMeta columnMeta : this.columnMetas) {
                columnMeta.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.rows)) {
            generator.writeKey("rows");
            generator.writeStartArray();
            for (Rows rows : this.rows) {
                rows.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPredictionResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::columnMetas, JsonpDeserializer.arrayDeserializer(ColumnMeta._DESERIALIZER), "column_metas");
        op.add(Builder::rows, JsonpDeserializer.arrayDeserializer(Rows._DESERIALIZER), "rows");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.columnMetas);
        result = 31 * result + Objects.hashCode(this.rows);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredictionResult other = (PredictionResult)o;
        return Objects.equals(this.columnMetas, other.columnMetas) && Objects.equals(this.rows, other.rows);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, PredictionResult> {
        @Nullable
        private List<ColumnMeta> columnMetas;
        @Nullable
        private List<Rows> rows;

        public Builder() {
        }

        private Builder(PredictionResult o) {
            this.columnMetas = Builder._listCopy(o.columnMetas);
            this.rows = Builder._listCopy(o.rows);
        }

        private Builder(Builder o) {
            this.columnMetas = Builder._listCopy(o.columnMetas);
            this.rows = Builder._listCopy(o.rows);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder columnMetas(List<ColumnMeta> list) {
            this.columnMetas = Builder._listAddAll(this.columnMetas, list);
            return this;
        }

        @Nonnull
        public final Builder columnMetas(ColumnMeta value, ColumnMeta ... values) {
            this.columnMetas = Builder._listAdd(this.columnMetas, value, values);
            return this;
        }

        @Nonnull
        public final Builder columnMetas(Function<ColumnMeta.Builder, ObjectBuilder<ColumnMeta>> fn) {
            return this.columnMetas(fn.apply(new ColumnMeta.Builder()).build(), new ColumnMeta[0]);
        }

        @Nonnull
        public final Builder rows(List<Rows> list) {
            this.rows = Builder._listAddAll(this.rows, list);
            return this;
        }

        @Nonnull
        public final Builder rows(Rows value, Rows ... values) {
            this.rows = Builder._listAdd(this.rows, value, values);
            return this;
        }

        @Nonnull
        public final Builder rows(Function<Rows.Builder, ObjectBuilder<Rows>> fn) {
            return this.rows(fn.apply(new Rows.Builder()).build(), new Rows[0]);
        }

        @Override
        @Nonnull
        public PredictionResult build() {
            this._checkSingleUse();
            return new PredictionResult(this);
        }
    }
}

