/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ml.ModelProfile;
import org.opensearch.client.opensearch.ml.Task;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Node
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Node> {
    @Nonnull
    private final Map<String, ModelProfile> models;
    @Nonnull
    private final Map<String, Task> tasks;
    public static final JsonpDeserializer<Node> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Node::setupNodeDeserializer);

    private Node(Builder builder) {
        this.models = ApiTypeHelper.unmodifiable(builder.models);
        this.tasks = ApiTypeHelper.unmodifiable(builder.tasks);
    }

    public static Node of(Function<Builder, ObjectBuilder<Node>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, ModelProfile> models() {
        return this.models;
    }

    @Nonnull
    public final Map<String, Task> tasks() {
        return this.tasks;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.models)) {
            generator.writeKey("models");
            generator.writeStartObject();
            for (Map.Entry<String, ModelProfile> entry : this.models.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.tasks)) {
            generator.writeKey("tasks");
            generator.writeStartObject();
            for (Map.Entry<String, ToCopyableBuilder<ModelProfile.Builder, ModelProfile>> entry : this.tasks.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Task)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::models, JsonpDeserializer.stringMapDeserializer(ModelProfile._DESERIALIZER), "models");
        op.add(Builder::tasks, JsonpDeserializer.stringMapDeserializer(Task._DESERIALIZER), "tasks");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.models);
        result = 31 * result + Objects.hashCode(this.tasks);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node other = (Node)o;
        return Objects.equals(this.models, other.models) && Objects.equals(this.tasks, other.tasks);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Node> {
        @Nullable
        private Map<String, ModelProfile> models;
        @Nullable
        private Map<String, Task> tasks;

        public Builder() {
        }

        private Builder(Node o) {
            this.models = Builder._mapCopy(o.models);
            this.tasks = Builder._mapCopy(o.tasks);
        }

        private Builder(Builder o) {
            this.models = Builder._mapCopy(o.models);
            this.tasks = Builder._mapCopy(o.tasks);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder models(Map<String, ModelProfile> map) {
            this.models = Builder._mapPutAll(this.models, map);
            return this;
        }

        @Nonnull
        public final Builder models(String key, ModelProfile value) {
            this.models = Builder._mapPut(this.models, key, value);
            return this;
        }

        @Nonnull
        public final Builder models(String key, Function<ModelProfile.Builder, ObjectBuilder<ModelProfile>> fn) {
            return this.models(key, fn.apply(new ModelProfile.Builder()).build());
        }

        @Nonnull
        public final Builder tasks(Map<String, Task> map) {
            this.tasks = Builder._mapPutAll(this.tasks, map);
            return this;
        }

        @Nonnull
        public final Builder tasks(String key, Task value) {
            this.tasks = Builder._mapPut(this.tasks, key, value);
            return this;
        }

        @Nonnull
        public final Builder tasks(String key, Function<Task.Builder, ObjectBuilder<Task>> fn) {
            return this.tasks(key, fn.apply(new Task.Builder()).build());
        }

        @Override
        @Nonnull
        public Node build() {
            this._checkSingleUse();
            return new Node(this);
        }
    }
}

