/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.SpanQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanQueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class SpanFieldMaskingQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final String field;
    private final SpanQuery query;
    public static final JsonpDeserializer<SpanFieldMaskingQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanFieldMaskingQuery::setupSpanFieldMaskingQueryDeserializer);

    private SpanFieldMaskingQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static SpanFieldMaskingQuery of(Function<Builder, ObjectBuilder<SpanFieldMaskingQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.FieldMaskingSpan;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.FieldMaskingSpan;
    }

    public final String field() {
        return this.field;
    }

    public final SpanQuery query() {
        return this.query;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).field(this.field).query(this.query);
    }

    protected static void setupSpanFieldMaskingQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::query, SpanQuery._DESERIALIZER, "query");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanFieldMaskingQuery> {
        private String field;
        private SpanQuery query;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder query(SpanQuery value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.query(fn.apply(new SpanQuery.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanFieldMaskingQuery build() {
            this._checkSingleUse();
            return new SpanFieldMaskingQuery(this);
        }
    }
}

