/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.GeoLocation;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.MetricAggregationBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class GeoCentroidAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Long count;
    @Nullable
    private final GeoLocation location;
    public static final JsonpDeserializer<GeoCentroidAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoCentroidAggregation::setupGeoCentroidAggregationDeserializer);

    private GeoCentroidAggregation(Builder builder) {
        super(builder);
        this.count = builder.count;
        this.location = builder.location;
    }

    public static GeoCentroidAggregation of(Function<Builder, ObjectBuilder<GeoCentroidAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeoCentroid;
    }

    @Nullable
    public final Long count() {
        return this.count;
    }

    @Nullable
    public final GeoLocation location() {
        return this.location;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count.longValue());
        }
        if (this.location != null) {
            generator.writeKey("location");
            this.location.serialize(generator, mapper);
        }
    }

    protected static void setupGeoCentroidAggregationDeserializer(ObjectDeserializer<Builder> op) {
        GeoCentroidAggregation.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::location, GeoLocation._DESERIALIZER, "location");
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoCentroidAggregation> {
        @Nullable
        private Long count;
        @Nullable
        private GeoLocation location;

        public final Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        public final Builder location(@Nullable GeoLocation value) {
            this.location = value;
            return this;
        }

        public final Builder location(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.location(fn.apply(new GeoLocation.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoCentroidAggregation build() {
            this._checkSingleUse();
            return new GeoCentroidAggregation(this);
        }
    }
}

