/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.mailbox;

import com.google.common.base.CharMatcher;

public class MessageMetaData {
    private static final CharMatcher IS_RFC1939_COMPATIBLE = CharMatcher.inRange((char)'!', (char)'~').precomputed();
    private final String uid;
    private final long size;

    public MessageMetaData(String uid, long size) {
        this.uid = uid;
        this.size = size;
        if (uid == null || !IS_RFC1939_COMPATIBLE.matchesAllOf((CharSequence)uid)) {
            throw new IllegalArgumentException("UID is not RFC1939 compatible");
        }
    }

    public String getUid() {
        return this.uid;
    }

    public String getUid(String mailboxId) {
        return this.uid;
    }

    public long getSize() {
        return this.size;
    }
}

