/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.opensearch;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.james.backends.opensearch.AliasName;
import org.apache.james.backends.opensearch.IndexName;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.WaitForActiveShards;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.CustomAnalyzer;
import org.opensearch.client.opensearch._types.analysis.CustomNormalizer;
import org.opensearch.client.opensearch._types.analysis.Normalizer;
import org.opensearch.client.opensearch._types.analysis.Tokenizer;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.ExistsAliasRequest;
import org.opensearch.client.opensearch.indices.ExistsRequest;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.IndexSettingsAnalysis;
import org.opensearch.client.opensearch.indices.UpdateAliasesRequest;
import org.opensearch.client.opensearch.indices.update_aliases.Action;
import org.opensearch.client.opensearch.indices.update_aliases.AddAction;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCreationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexCreationFactory.class);
    private static final String INDEX_ALREADY_EXISTS_EXCEPTION_MESSAGE = "type=resource_already_exists_exception";
    private final int nbShards;
    private final int nbReplica;
    private final int waitForActiveShards;
    public static final String CASE_INSENSITIVE = "case_insensitive";
    public static final String KEEP_MAIL_AND_URL = "keep_mail_and_url";
    public static final String BOOLEAN = "boolean";
    public static final String TYPE = "type";
    public static final String LONG = "long";
    public static final String DOUBLE = "double";
    public static final String KEYWORD = "keyword";
    public static final String PROPERTIES = "properties";
    public static final String ROUTING = "_routing";
    public static final String REQUIRED = "required";
    public static final String DATE = "date";
    public static final String FORMAT = "format";
    public static final String NESTED = "nested";
    public static final String FIELDS = "fields";
    public static final String RAW = "raw";
    public static final String ANALYZER = "analyzer";
    public static final String TOKENIZER = "tokenizer";
    public static final String NORMALIZER = "normalizer";
    public static final String SEARCH_ANALYZER = "search_analyzer";

    @Inject
    public IndexCreationFactory(OpenSearchConfiguration configuration) {
        this.nbShards = configuration.getNbShards();
        this.nbReplica = configuration.getNbReplica();
        this.waitForActiveShards = configuration.getWaitForActiveShards();
    }

    public IndexCreationPerformer.Builder.FinalStage useIndex(IndexName indexName) {
        Preconditions.checkNotNull((Object)indexName);
        return IndexCreationPerformer.builder().nbShards(this.nbShards).nbReplica(this.nbReplica).waitForActiveShards(this.waitForActiveShards).indexName(indexName);
    }

    static class IndexCreationPerformer {
        private final int nbShards;
        private final int nbReplica;
        private final int waitForActiveShards;
        private final IndexName indexName;
        private final ImmutableList<AliasName> aliases;
        private final ImmutableList<IndexCreationCustomAnalyzer> customAnalyzers;
        private final ImmutableList<IndexCreationCustomTokenizer> customTokenizers;

        public static Builder.RequireNbShards builder() {
            return nbShards -> nbReplica -> waitForActiveShards -> indexName -> new Builder.FinalStage(nbShards, nbReplica, waitForActiveShards, indexName);
        }

        private IndexCreationPerformer(int nbShards, int nbReplica, int waitForActiveShards, IndexName indexName, ImmutableList<AliasName> aliases, ImmutableList<IndexCreationCustomAnalyzer> customAnalyzers, ImmutableList<IndexCreationCustomTokenizer> customTokenizers) {
            this.nbShards = nbShards;
            this.nbReplica = nbReplica;
            this.waitForActiveShards = waitForActiveShards;
            this.indexName = indexName;
            this.aliases = aliases;
            this.customAnalyzers = customAnalyzers;
            this.customTokenizers = customTokenizers;
        }

        public ReactorOpenSearchClient createIndexAndAliases(ReactorOpenSearchClient client, Optional<IndexSettings> indexSettings, Optional<TypeMapping> mappingContent) {
            Preconditions.checkNotNull((Object)this.indexName);
            try {
                this.createIndexIfNeeded(client, this.indexName, indexSettings.orElse(this.generateSetting()), mappingContent);
                this.aliases.forEach(Throwing.consumer(alias -> this.createAliasIfNeeded(client, this.indexName, (AliasName)alias)).sneakyThrow());
            }
            catch (IOException e) {
                LOGGER.error("Error while creating index : ", (Throwable)e);
            }
            return client;
        }

        private void createAliasIfNeeded(ReactorOpenSearchClient client, IndexName indexName, AliasName aliasName) throws IOException {
            if (!this.aliasExist(client, aliasName)) {
                client.updateAliases(new UpdateAliasesRequest.Builder().actions((Action)new Action.Builder().add(new AddAction.Builder().index(indexName.getValue()).alias(aliasName.getValue()).build()).build(), new Action[0]).build()).block();
            }
        }

        private boolean aliasExist(ReactorOpenSearchClient client, AliasName aliasName) throws IOException {
            return (Boolean)client.aliasExists(new ExistsAliasRequest.Builder().name(aliasName.getValue(), new String[0]).build()).map(BooleanResponse::value).block();
        }

        private void createIndexIfNeeded(ReactorOpenSearchClient client, IndexName indexName, IndexSettings settings, Optional<TypeMapping> mappingContent) throws IOException {
            try {
                if (!this.indexExists(client, indexName)) {
                    CreateIndexRequest.Builder request = new CreateIndexRequest.Builder().index(indexName.getValue()).waitForActiveShards((WaitForActiveShards)new WaitForActiveShards.Builder().count(Integer.valueOf(this.waitForActiveShards)).build()).settings(settings);
                    mappingContent.ifPresent(arg_0 -> ((CreateIndexRequest.Builder)request).mappings(arg_0));
                    client.createIndex(request.build()).block();
                }
            }
            catch (OpenSearchException exception) {
                if (exception.getMessage().contains(IndexCreationFactory.INDEX_ALREADY_EXISTS_EXCEPTION_MESSAGE)) {
                    LOGGER.info("Index [{}] already exists", (Object)indexName.getValue());
                }
                throw exception;
            }
        }

        private boolean indexExists(ReactorOpenSearchClient client, IndexName indexName) throws IOException {
            return (Boolean)client.indexExists(new ExistsRequest.Builder().index(indexName.getValue(), new String[0]).build()).map(BooleanResponse::value).block();
        }

        private IndexSettings generateSetting() {
            return new IndexSettings.Builder().numberOfShards(Integer.toString(this.nbShards)).numberOfReplicas(Integer.toString(this.nbReplica)).analysis(new IndexSettingsAnalysis.Builder().normalizer(IndexCreationFactory.CASE_INSENSITIVE, (Normalizer)new Normalizer.Builder().custom(this.generateNormalizer()).build()).analyzer(this.generateAnalyzers()).tokenizer(this.generateTokenizers()).build()).build();
        }

        private CustomNormalizer generateNormalizer() {
            return new CustomNormalizer.Builder().filter("lowercase", new String[]{"asciifolding"}).build();
        }

        private Map<String, Analyzer> defaultAnalyzers() {
            return ImmutableMap.of((Object)IndexCreationFactory.KEEP_MAIL_AND_URL, (Object)((Analyzer)new Analyzer.Builder().custom(new CustomAnalyzer.Builder().tokenizer("uax_url_email").filter("lowercase", new String[]{"stop"}).build()).build()));
        }

        private Map<String, Analyzer> generateAnalyzers() {
            if (this.customAnalyzers.isEmpty()) {
                return this.defaultAnalyzers();
            }
            return this.customAnalyzers.stream().collect(Collectors.toMap(IndexCreationCustomAnalyzer::getKey, IndexCreationCustomAnalyzer::getAnalyzer));
        }

        private Map<String, Tokenizer> generateTokenizers() {
            return this.customTokenizers.stream().collect(Collectors.toMap(IndexCreationCustomTokenizer::getKey, IndexCreationCustomTokenizer::getTokenizer));
        }

        public static class Builder {

            public static class FinalStage {
                private final int nbShards;
                private final int nbReplica;
                private final int waitForActiveShards;
                private final IndexName indexName;
                private final ImmutableList.Builder<AliasName> aliases;
                private final ImmutableList.Builder<IndexCreationCustomAnalyzer> customAnalyzers;
                private final ImmutableList.Builder<IndexCreationCustomTokenizer> customTokenizers;

                FinalStage(int nbShards, int nbReplica, int waitForActiveShards, IndexName indexName) {
                    this.nbShards = nbShards;
                    this.nbReplica = nbReplica;
                    this.waitForActiveShards = waitForActiveShards;
                    this.indexName = indexName;
                    this.aliases = ImmutableList.builder();
                    this.customAnalyzers = ImmutableList.builder();
                    this.customTokenizers = ImmutableList.builder();
                }

                public FinalStage addAlias(AliasName ... aliases) {
                    this.aliases.add((Object[])aliases);
                    return this;
                }

                public FinalStage addAlias(Collection<AliasName> aliases) {
                    this.aliases.addAll((Iterable)ImmutableList.copyOf(aliases));
                    return this;
                }

                public FinalStage customAnalyzers(IndexCreationCustomAnalyzer ... customAnalyzers) {
                    this.customAnalyzers.add((Object[])customAnalyzers);
                    return this;
                }

                public FinalStage customTokenizers(IndexCreationCustomTokenizer ... customTokenizers) {
                    this.customTokenizers.add((Object[])customTokenizers);
                    return this;
                }

                public IndexCreationPerformer build() {
                    return new IndexCreationPerformer(this.nbShards, this.nbReplica, this.waitForActiveShards, this.indexName, (ImmutableList<AliasName>)this.aliases.build(), (ImmutableList<IndexCreationCustomAnalyzer>)this.customAnalyzers.build(), (ImmutableList<IndexCreationCustomTokenizer>)this.customTokenizers.build());
                }

                public ReactorOpenSearchClient createIndexAndAliases(ReactorOpenSearchClient client) {
                    return this.build().createIndexAndAliases(client, Optional.empty(), Optional.empty());
                }

                public ReactorOpenSearchClient createIndexAndAliases(ReactorOpenSearchClient client, TypeMapping mappingContent) {
                    return this.build().createIndexAndAliases(client, Optional.empty(), Optional.of(mappingContent));
                }

                public ReactorOpenSearchClient createIndexAndAliases(ReactorOpenSearchClient client, Optional<IndexSettings> indexSettings, Optional<TypeMapping> mappingContent) {
                    return this.build().createIndexAndAliases(client, indexSettings, mappingContent);
                }
            }

            @FunctionalInterface
            public static interface RequireIndexName {
                public FinalStage indexName(IndexName var1);
            }

            @FunctionalInterface
            public static interface RequireWaitForActiveShards {
                public RequireIndexName waitForActiveShards(int var1);
            }

            @FunctionalInterface
            public static interface RequireNbReplica {
                public RequireWaitForActiveShards nbReplica(int var1);
            }

            @FunctionalInterface
            public static interface RequireNbShards {
                public RequireNbReplica nbShards(int var1);
            }
        }
    }

    public static class IndexCreationCustomTokenizer {
        private final String key;
        private final Tokenizer tokenizer;

        public IndexCreationCustomTokenizer(String key, Tokenizer tokenizer) {
            this.key = key;
            this.tokenizer = tokenizer;
        }

        public String getKey() {
            return this.key;
        }

        public Tokenizer getTokenizer() {
            return this.tokenizer;
        }
    }

    public static class IndexCreationCustomAnalyzer {
        private final String key;
        private final Analyzer analyzer;

        public IndexCreationCustomAnalyzer(String key, Analyzer analyzer) {
            this.key = key;
            this.analyzer = analyzer;
        }

        public String getKey() {
            return this.key;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }
    }
}

