/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndriScorer;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;

public abstract class IndriDisjunctionScorer
extends IndriScorer {
    private final List<Scorer> subScorersList;
    private final DocIdSetIterator approximation;

    protected IndriDisjunctionScorer(List<Scorer> subScorersList, ScoreMode scoreMode, float boost) {
        super(boost);
        this.subScorersList = subScorersList;
        ArrayList<DisiWrapper> wrappers = new ArrayList<DisiWrapper>();
        for (Scorer scorer : subScorersList) {
            DisiWrapper w = new DisiWrapper(scorer, false);
            wrappers.add(w);
        }
        this.approximation = new DisjunctionDISIApproximation(wrappers, Long.MAX_VALUE);
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.approximation;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return 0.0f;
    }

    public List<Scorer> getSubMatches() throws IOException {
        return this.subScorersList;
    }

    abstract float score(List<Scorer> var1) throws IOException;

    public abstract float smoothingScore(List<Scorer> var1, int var2) throws IOException;

    @Override
    public float score() throws IOException {
        return this.score(this.getSubMatches());
    }

    @Override
    public float smoothingScore(int docId) throws IOException {
        return this.smoothingScore(this.getSubMatches(), docId);
    }

    @Override
    public int docID() {
        return this.approximation.docID();
    }
}

