/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToRepository
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToRepository.class);
    private final MailRepositoryStore mailStore;
    private MailRepository repository;
    private MailRepositoryUrl repositoryPath;
    private boolean passThrough = false;

    @Inject
    public ToRepository(MailRepositoryStore mailStore) {
        this.mailStore = mailStore;
    }

    public void init() throws MessagingException {
        this.repositoryPath = MailRepositoryUrl.from((String)this.getInitParameter("repositoryPath"));
        this.passThrough = this.getPassThroughParameter();
        this.repository = this.selectRepository();
    }

    private boolean getPassThroughParameter() {
        try {
            return this.getInitParameter("passThrough", false);
        }
        catch (Exception e) {
            return false;
        }
    }

    private MailRepository selectRepository() throws MessagingException {
        try {
            return this.mailStore.select(this.repositoryPath);
        }
        catch (Exception e) {
            throw new MessagingException("Failed to retrieve MailRepository for url " + String.valueOf(this.repositoryPath), e);
        }
    }

    public void service(Mail mail) throws MessagingException {
        String logBuffer = "Storing mail " + mail.getName() + " in " + String.valueOf(this.repositoryPath);
        LOGGER.info(logBuffer);
        this.repository.store(mail);
        if (!this.passThrough) {
            mail.setState("ghost");
        }
    }

    public String getMailetInfo() {
        return "ToRepository Mailet";
    }
}

