/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib.model;

import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.model.Algorithm;

public class DefaultUser
implements User,
Serializable {
    private static final long serialVersionUID = 5178048915868531270L;
    private final Username userName;
    private String hashedPassword;
    private Algorithm currentAlgorithm;
    private final Algorithm preferredAlgorithm;

    public DefaultUser(Username name, Algorithm verifyAlg, Algorithm updateAlg) {
        this.userName = name;
        this.currentAlgorithm = verifyAlg;
        this.preferredAlgorithm = updateAlg;
    }

    public DefaultUser(Username name, String passwordHash, Algorithm verifyAlg, Algorithm updateAlg) {
        this.userName = name;
        this.hashedPassword = passwordHash;
        this.currentAlgorithm = verifyAlg;
        this.preferredAlgorithm = updateAlg;
    }

    public Username getUserName() {
        return this.userName;
    }

    public boolean verifyPassword(String pass) {
        String hashGuess = DefaultUser.digestString(pass, this.currentAlgorithm, this.userName.asString());
        return this.hashedPassword.equals(hashGuess);
    }

    public boolean setPassword(String newPass) {
        this.hashedPassword = DefaultUser.digestString(newPass, this.preferredAlgorithm, this.userName.asString());
        this.currentAlgorithm = this.preferredAlgorithm;
        return true;
    }

    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public Algorithm getHashAlgorithm() {
        return this.currentAlgorithm;
    }

    static String digestString(String pass, Algorithm algorithm, String salt) {
        return algorithm.digest(pass, salt);
    }
}

