/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.postgres;

import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Optional;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Username;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.NotificationRegistry;
import org.apache.james.vacation.api.RecipientId;
import org.apache.james.vacation.postgres.PostgresNotificationRegistryDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class PostgresNotificationRegistry
implements NotificationRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresNotificationRegistry.class);
    private final ZonedDateTimeProvider zonedDateTimeProvider;
    private final PostgresExecutor.Factory executorFactory;

    @Inject
    public PostgresNotificationRegistry(ZonedDateTimeProvider zonedDateTimeProvider, PostgresExecutor.Factory executorFactory) {
        this.zonedDateTimeProvider = zonedDateTimeProvider;
        this.executorFactory = executorFactory;
    }

    public Mono<Void> register(AccountId accountId, RecipientId recipientId, Optional<ZonedDateTime> expiryDate) {
        if (this.isValid(expiryDate)) {
            return this.notificationRegistryDAO(accountId).register(accountId, recipientId, expiryDate);
        }
        LOGGER.warn("Invalid vacation notification expiry date for {} {} : {}", new Object[]{accountId, recipientId, expiryDate});
        return Mono.empty();
    }

    public Mono<Boolean> isRegistered(AccountId accountId, RecipientId recipientId) {
        return this.notificationRegistryDAO(accountId).isRegistered(accountId, recipientId);
    }

    public Mono<Void> flush(AccountId accountId) {
        return this.notificationRegistryDAO(accountId).flush(accountId);
    }

    private boolean isValid(Optional<ZonedDateTime> expiryDate) {
        return expiryDate.isEmpty() || expiryDate.get().isAfter((ChronoZonedDateTime)this.zonedDateTimeProvider.get());
    }

    private PostgresNotificationRegistryDAO notificationRegistryDAO(AccountId accountId) {
        return new PostgresNotificationRegistryDAO(this.executorFactory.create(Username.of((String)accountId.getIdentifier()).getDomainPart()), this.zonedDateTimeProvider);
    }
}

