/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.google.inject.name.Named;
import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.PostgresqlConnectionFactory;
import io.r2dbc.spi.ConnectionFactory;
import java.io.FileNotFoundException;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.postgres.PostgresConfiguration;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresTableManager;
import org.apache.james.backends.postgres.RowLevelSecurity;
import org.apache.james.backends.postgres.utils.JamesPostgresConnectionFactory;
import org.apache.james.backends.postgres.utils.PoolBackedPostgresConnectionFactory;
import org.apache.james.backends.postgres.utils.PostgresConnectionClosure;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.backends.postgres.utils.PostgresHealthCheck;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresCommonModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"POSTGRES");

    public void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), PostgresDataDefinition.class);
        this.bind(PostgresExecutor.Factory.class).in(Scopes.SINGLETON);
        this.bind(PostgresConnectionClosure.class).asEagerSingleton();
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(PostgresHealthCheck.class);
    }

    @Provides
    @Singleton
    PostgresConfiguration provideConfiguration(PropertiesProvider propertiesProvider) throws FileNotFoundException, ConfigurationException {
        return PostgresConfiguration.from((Configuration)propertiesProvider.getConfiguration("postgres"));
    }

    @Provides
    @Singleton
    JamesPostgresConnectionFactory provideJamesPostgresConnectionFactory(PostgresConfiguration postgresConfiguration, ConnectionFactory connectionFactory) {
        return new PoolBackedPostgresConnectionFactory(postgresConfiguration.getRowLevelSecurity(), postgresConfiguration.poolInitialSize().intValue(), postgresConfiguration.poolMaxSize().intValue(), connectionFactory);
    }

    @Provides
    @Named(value="by_pass_rls")
    @Singleton
    JamesPostgresConnectionFactory provideJamesPostgresConnectionFactoryWithRLSBypass(PostgresConfiguration postgresConfiguration, JamesPostgresConnectionFactory jamesPostgresConnectionFactory, @Named(value="by_pass_rls") ConnectionFactory connectionFactory) {
        if (!postgresConfiguration.getRowLevelSecurity().isRowLevelSecurityEnabled()) {
            return jamesPostgresConnectionFactory;
        }
        return new PoolBackedPostgresConnectionFactory(RowLevelSecurity.DISABLED, postgresConfiguration.byPassRLSPoolInitialSize().intValue(), postgresConfiguration.byPassRLSPoolMaxSize().intValue(), connectionFactory);
    }

    @Provides
    @Singleton
    ConnectionFactory postgresqlConnectionFactory(PostgresConfiguration postgresConfiguration) {
        return new PostgresqlConnectionFactory(PostgresqlConnectionConfiguration.builder().host(postgresConfiguration.getHost()).port(postgresConfiguration.getPort()).username(postgresConfiguration.getDefaultCredential().getUsername()).password((CharSequence)postgresConfiguration.getDefaultCredential().getPassword()).database(postgresConfiguration.getDatabaseName()).schema(postgresConfiguration.getDatabaseSchema()).sslMode(postgresConfiguration.getSslMode()).build());
    }

    @Provides
    @Named(value="by_pass_rls")
    @Singleton
    ConnectionFactory postgresqlConnectionFactoryRLSBypass(PostgresConfiguration postgresConfiguration) {
        return new PostgresqlConnectionFactory(PostgresqlConnectionConfiguration.builder().host(postgresConfiguration.getHost()).port(postgresConfiguration.getPort()).username(postgresConfiguration.getByPassRLSCredential().getUsername()).password((CharSequence)postgresConfiguration.getByPassRLSCredential().getPassword()).database(postgresConfiguration.getDatabaseName()).schema(postgresConfiguration.getDatabaseSchema()).sslMode(postgresConfiguration.getSslMode()).build());
    }

    @Provides
    @Singleton
    PostgresDataDefinition composePostgresDataDefinitions(Set<PostgresDataDefinition> modules) {
        return PostgresDataDefinition.aggregateModules(modules);
    }

    @Provides
    @Singleton
    PostgresTableManager postgresTableManager(PostgresExecutor postgresExecutor, PostgresDataDefinition postgresDataDefinition, PostgresConfiguration postgresConfiguration) {
        return new PostgresTableManager(postgresExecutor, postgresDataDefinition, postgresConfiguration);
    }

    @Provides
    @Named(value="by_pass_rls")
    @Singleton
    PostgresExecutor.Factory postgresExecutorFactoryWithRLSBypass(@Named(value="by_pass_rls") JamesPostgresConnectionFactory singlePostgresConnectionFactory, PostgresConfiguration postgresConfiguration, MetricFactory metricFactory) {
        return new PostgresExecutor.Factory(singlePostgresConnectionFactory, postgresConfiguration, metricFactory);
    }

    @Provides
    @Named(value="default")
    @Singleton
    PostgresExecutor defaultPostgresExecutor(PostgresExecutor.Factory factory) {
        return factory.create();
    }

    @Provides
    @Named(value="by_pass_rls")
    @Singleton
    PostgresExecutor postgresExecutorWithRLSBypass(@Named(value="by_pass_rls") PostgresExecutor.Factory factory) {
        return factory.create();
    }

    @Provides
    @Singleton
    PostgresExecutor postgresExecutor(@Named(value="default") PostgresExecutor postgresExecutor) {
        return postgresExecutor;
    }

    @ProvidesIntoSet
    InitializationOperation provisionPostgresTablesAndIndexes(PostgresTableManager postgresTableManager) {
        return InitilizationOperationBuilder.forClass(PostgresTableManager.class, (int)1).init(() -> ((PostgresTableManager)postgresTableManager).initPostgres());
    }
}

