/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.policies;

import java.util.List;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSRequest;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.SPF1Record;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerDNSResponseListener;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.core.exceptions.TimeoutException;

public class SPFRetriever
implements SPFChecker {
    private static final boolean CHECK_ONLY_TXT_RECORDS = false;

    protected static String extractSPFRecord(List<String> spfR) throws PermErrorException {
        if (spfR == null || spfR.isEmpty()) {
            return null;
        }
        String returnValue = null;
        for (String compare : spfR) {
            if (!compare.toLowerCase().trim().startsWith("v=spf1 ") && !compare.trim().equalsIgnoreCase("v=spf1")) continue;
            if (returnValue == null) {
                returnValue = compare;
                continue;
            }
            throw new PermErrorException("More than 1 SPF record found");
        }
        return returnValue;
    }

    @Override
    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        SPF1Record res = (SPF1Record)spfData.getAttribute("SPF.SPF1Record");
        if (res == null) {
            String currentDomain = spfData.getCurrentDomain();
            return new DNSLookupContinuation(new DNSRequest(currentDomain, 6), new SPFRetrieverDNSResponseListener());
        }
        return null;
    }

    private static final class SPFRetrieverDNSResponseListener
    implements SPFCheckerDNSResponseListener {
        private SPFRetrieverDNSResponseListener() {
        }

        @Override
        public DNSLookupContinuation onDNSResponse(DNSResponse response, SPFSession session) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            try {
                List<String> spfR = response.getResponse();
                if (spfR == null || spfR.isEmpty()) {
                    String currentDomain = session.getCurrentDomain();
                    return new DNSLookupContinuation(new DNSRequest(currentDomain, 5), new SPFRecordHandlerDNSResponseListener());
                }
                String record = SPFRetriever.extractSPFRecord(spfR);
                if (record != null) {
                    session.setAttribute("SPF.SPF1Record", new SPF1Record(record));
                }
                return null;
            }
            catch (TimeoutException e) {
                throw new TempErrorException("Timeout querying dns");
            }
        }
    }

    private static final class SPFRecordHandlerDNSResponseListener
    implements SPFCheckerDNSResponseListener {
        private SPFRecordHandlerDNSResponseListener() {
        }

        @Override
        public DNSLookupContinuation onDNSResponse(DNSResponse response, SPFSession session) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            try {
                List<String> spfR = response.getResponse();
                String record = SPFRetriever.extractSPFRecord(spfR);
                if (record != null) {
                    session.setAttribute("SPF.SPF1Record", new SPF1Record(record));
                }
            }
            catch (TimeoutException e) {
                throw new TempErrorException("Timeout querying dns");
            }
            return null;
        }
    }
}

