/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HeloHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhloCmdHandler
extends AbstractHookableCmdHandler<HeloHook>
implements EhloExtension {
    private static final String COMMAND_NAME = "EHLO";
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"EHLO");
    private static final List<String> ESMTP_FEATURES = ImmutableList.of((Object)"PIPELINING", (Object)"ENHANCEDSTATUSCODES", (Object)"8BITMIME");
    private static final Response DOMAIN_ADDRESS_REQUIRED = new SMTPResponse("501", DSNStatus.getStatus(5, "5.4") + " Domain address required: EHLO").immutable();
    private static final Logger LOGGER = LoggerFactory.getLogger(EhloCmdHandler.class);
    private static final CharMatcher ALPHANUMERIC_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9'));
    private List<EhloExtension> ehloExtensions;

    @Inject
    public EhloCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    private Response doEHLO(SMTPSession session, String argument) {
        if (!this.isValid(argument)) {
            LOGGER.error("Invalid EHLO argument received: {} which must be a domain name or an IP address.", (Object)argument);
            return new SMTPResponse("501", DSNStatus.getStatus(5, "5.2") + " Invalid domain name or ip supplied as HELO argument");
        }
        SMTPResponse resp = new SMTPResponse("250", new StringBuilder(session.getConfiguration().getHelloName()).append(" Hello ").append(argument).append(" [").append(session.getRemoteAddress().getAddress().getHostAddress()).append("])"));
        session.setAttachment(SMTPSession.CURRENT_HELO_MODE, COMMAND_NAME, ProtocolSession.State.Connection);
        this.processExtensions(session, resp);
        LOGGER.debug("EHLO {}", (Object)StringUtils.abbreviate((String)argument, (int)80));
        return resp;
    }

    private boolean isValid(String argument) {
        String hostname = this.unquote(argument);
        return InetAddresses.isUriInetAddress((String)hostname) || InetAddresses.isUriInetAddress((String)("[" + EhloCmdHandler.removeEmIPV6Prefix(hostname) + "]")) || InternetDomainName.isValid((String)hostname) || this.emClientCompatibility(hostname) || this.isAlphanumeric(hostname);
    }

    private boolean isAlphanumeric(String hostname) {
        return !hostname.isEmpty() && ALPHANUMERIC_MATCHER.matchesAllOf((CharSequence)hostname);
    }

    private boolean emClientCompatibility(String hostname) {
        int separator = hostname.lastIndexOf(58);
        if (separator == -1 || separator == hostname.length() - 1) {
            return false;
        }
        String ipv4 = hostname.substring(separator + 1);
        String ipv6 = EhloCmdHandler.removeEmIPV6Prefix(hostname.substring(0, separator));
        boolean isIPv6 = InetAddresses.isInetAddress((String)ipv6) || InetAddresses.isUriInetAddress((String)ipv6) || InetAddresses.isUriInetAddress((String)("[" + ipv6 + "]"));
        return InetAddresses.isInetAddress((String)ipv4) && isIPv6;
    }

    private static String removeEmIPV6Prefix(String ipv6) {
        if (ipv6.toLowerCase(Locale.US).startsWith("ipv6:")) {
            ipv6 = ipv6.substring(5);
        }
        return ipv6;
    }

    private String unquote(String argument) {
        if (argument.startsWith("[") && argument.endsWith("]")) {
            return argument.substring(1, argument.length() - 1);
        }
        return argument;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    public List<Class<?>> getMarkerInterfaces() {
        List<Class<?>> classes = super.getMarkerInterfaces();
        classes.add(EhloExtension.class);
        return classes;
    }

    @Override
    public void wireExtensions(Class<?> interfaceName, List<?> extension) {
        super.wireExtensions(interfaceName, extension);
        if (EhloExtension.class.equals(interfaceName)) {
            this.ehloExtensions = extension;
        }
    }

    private void processExtensions(SMTPSession session, SMTPResponse resp) {
        if (this.ehloExtensions != null) {
            for (EhloExtension ehloExtension : this.ehloExtensions) {
                List<String> lines = ehloExtension.getImplementedEsmtpFeatures(session);
                if (lines == null) continue;
                for (String line : lines) {
                    resp.appendLine(line);
                }
            }
        }
    }

    @Override
    protected Response doCoreCmd(SMTPSession session, String command, String parameters) {
        return this.doEHLO(session, parameters);
    }

    @Override
    protected Response doFilterChecks(SMTPSession session, String command, String parameters) {
        session.resetState();
        if (parameters == null) {
            return DOMAIN_ADDRESS_REQUIRED;
        }
        session.setAttachment(SMTPSession.CURRENT_HELO_NAME, parameters, ProtocolSession.State.Connection);
        return null;
    }

    @Override
    protected Class<HeloHook> getHookInterface() {
        return HeloHook.class;
    }

    @Override
    protected HookResult callHook(HeloHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doHelo(session, parameters);
    }

    @Override
    public List<String> getImplementedEsmtpFeatures(SMTPSession session) {
        ImmutableSet esmtpFeatures = ImmutableSet.builder().addAll(ESMTP_FEATURES).addAll((Iterable)this.getHooks().stream().flatMap(heloHook -> heloHook.implementedEsmtpFeatures(session).stream()).collect(ImmutableList.toImmutableList())).build();
        return ImmutableList.copyOf((Collection)Sets.difference((Set)esmtpFeatures, session.disabledFeatures()));
    }
}

