/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Array;
import java.util.Objects;

public abstract class AbstractListToArrayCodec<ArrayT>
implements TypeCodec<ArrayT> {
    @NonNull
    protected final ListType cqlType;
    @NonNull
    protected final GenericType<ArrayT> javaType;

    protected AbstractListToArrayCodec(@NonNull ListType cqlType, @NonNull GenericType<ArrayT> arrayType) {
        this.cqlType = Objects.requireNonNull(cqlType, "cqlType cannot be null");
        this.javaType = Objects.requireNonNull(arrayType, "arrayType cannot be null");
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("Expecting Java array class, got " + arrayType);
        }
    }

    @Override
    @NonNull
    public GenericType<ArrayT> getJavaType() {
        return this.javaType;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    @NonNull
    public String format(@Nullable ArrayT array) {
        if (array == null) {
            return "NULL";
        }
        int length = Array.getLength(array);
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            this.formatElement(sb, array, i);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    @Nullable
    public ArrayT parse(@Nullable String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        int idx = this.skipSpaces(value, 0);
        idx = this.skipOpeningBracket(value, idx);
        if (value.charAt(idx = this.skipSpaces(value, idx)) == ']') {
            return this.newInstance(0);
        }
        int length = this.getArrayLength(value, idx);
        ArrayT array = this.newInstance(length);
        int i = 0;
        while (idx < value.length()) {
            int n = this.skipLiteral(value, idx);
            this.parseElement(value.substring(idx, n), array, i);
            idx = this.skipSpaces(value, n);
            if (value.charAt(idx) == ']') {
                return array;
            }
            idx = this.skipComma(value, idx);
            idx = this.skipSpaces(value, idx);
            ++i;
        }
        throw new IllegalArgumentException(String.format("Malformed list value \"%s\", missing closing ']'", value));
    }

    @NonNull
    protected abstract ArrayT newInstance(int var1);

    protected abstract void formatElement(@NonNull StringBuilder var1, @NonNull ArrayT var2, int var3);

    protected abstract void parseElement(@NonNull String var1, @NonNull ArrayT var2, int var3);

    private int getArrayLength(String value, int idx) {
        int length = 1;
        while (idx < value.length()) {
            idx = this.skipLiteral(value, idx);
            if (value.charAt(idx = this.skipSpaces(value, idx)) == ']') break;
            idx = this.skipComma(value, idx);
            idx = this.skipSpaces(value, idx);
            ++length;
        }
        return length;
    }

    private int skipComma(String value, int idx) {
        if (value.charAt(idx) != ',') {
            throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", at character %d expecting ',' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
        }
        return idx + 1;
    }

    private int skipOpeningBracket(String value, int idx) {
        if (value.charAt(idx) != '[') {
            throw new IllegalArgumentException(String.format("cannot parse list value from \"%s\", at character %d expecting '[' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
        }
        return idx + 1;
    }

    private int skipSpaces(String value, int idx) {
        try {
            return ParseUtils.skipSpaces(value, idx);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", at character %d expecting space but got '%c'", value, idx, Character.valueOf(value.charAt(idx))), e);
        }
    }

    private int skipLiteral(String value, int idx) {
        try {
            return ParseUtils.skipCQLValue(value, idx);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", invalid CQL value at character %d", value, idx), e);
        }
    }
}

