/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type.reflect;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import net.jcip.annotations.Immutable;

@Immutable
public class GenericTypeParameter<T> {
    private final TypeVariable<?> typeVariable;

    protected GenericTypeParameter() {
        Type superclass = this.getClass().getGenericSuperclass();
        Preconditions.checkArgument((boolean)(superclass instanceof ParameterizedType), (String)"%s isn't parameterized", (Object)superclass);
        this.typeVariable = (TypeVariable)((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    @NonNull
    public TypeVariable<?> getTypeVariable() {
        return this.typeVariable;
    }
}

