/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.Describable;
import com.datastax.oss.driver.api.core.metadata.schema.IndexKind;
import com.datastax.oss.driver.internal.core.metadata.schema.ScriptBuilder;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Optional;

public interface IndexMetadata
extends Describable {
    @NonNull
    public CqlIdentifier getKeyspace();

    @NonNull
    public CqlIdentifier getTable();

    @NonNull
    public CqlIdentifier getName();

    @NonNull
    public IndexKind getKind();

    @NonNull
    public String getTarget();

    @NonNull
    default public Optional<String> getClassName() {
        return Optional.ofNullable(this.getOptions().get("class_name"));
    }

    @NonNull
    public Map<String, String> getOptions();

    @Override
    @NonNull
    default public String describe(boolean pretty) {
        ScriptBuilder builder = new ScriptBuilder(pretty);
        if (this.getClassName().isPresent()) {
            builder.append("CREATE CUSTOM INDEX ").append(this.getName()).append(" ON ").append(this.getKeyspace()).append(".").append(this.getTable()).append(String.format(" (%s)", this.getTarget())).newLine().append(String.format("USING '%s'", this.getClassName().get()));
            Map describedOptions = Maps.filterKeys(this.getOptions(), k -> !"target".equals(k) && !"class_name".equals(k));
            if (!describedOptions.isEmpty()) {
                builder.newLine().append("WITH OPTIONS = {").newLine().increaseIndent();
                boolean first = true;
                for (Map.Entry option : describedOptions.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(",").newLine();
                    }
                    builder.append(String.format("'%s' : '%s'", option.getKey(), option.getValue()));
                }
                builder.decreaseIndent().append("}");
            }
        } else {
            builder.append("CREATE INDEX ").append(this.getName()).append(" ON ").append(this.getKeyspace()).append(".").append(this.getTable()).append(String.format(" (%s);", this.getTarget()));
        }
        return builder.build();
    }

    @Override
    @NonNull
    default public String describeWithChildren(boolean pretty) {
        return this.describe(pretty);
    }
}

