/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata.schema.parsing;

import com.datastax.dse.driver.api.core.metadata.schema.DseAggregateMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.DefaultDseAggregateMetadata;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.AggregateParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeParser;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DseAggregateParser {
    private final AggregateParser aggregateParser;
    private final InternalDriverContext context;

    public DseAggregateParser(DataTypeParser dataTypeParser, InternalDriverContext context) {
        this.aggregateParser = new AggregateParser(dataTypeParser, context);
        this.context = context;
    }

    public DseAggregateMetadata parseAggregate(AdminRow row, CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> userDefinedTypes) {
        AggregateMetadata aggregate = this.aggregateParser.parseAggregate(row, keyspaceId, userDefinedTypes);
        Boolean deterministic = row.contains("deterministic") ? row.getBoolean("deterministic") : null;
        return new DefaultDseAggregateMetadata(aggregate.getKeyspace(), aggregate.getSignature(), aggregate.getFinalFuncSignature().orElse(null), aggregate.getInitCond().orElse(null), aggregate.getReturnType(), aggregate.getStateFuncSignature(), aggregate.getStateType(), this.context.getCodecRegistry().codecFor(aggregate.getStateType()), deterministic);
    }
}

