/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ParsedAttachment;
import org.apache.james.mailbox.model.StringBackedAttachmentId;
import org.apache.james.mailbox.store.mail.AttachmentMapper;

public class InMemoryAttachmentMapper
implements AttachmentMapper {
    private static final int INITIAL_SIZE = 128;
    private final Map<AttachmentId, AttachmentMetadata> attachmentsById = new ConcurrentHashMap<AttachmentId, AttachmentMetadata>(128);
    private final Map<AttachmentId, byte[]> attachmentsRawContentById = new ConcurrentHashMap<AttachmentId, byte[]>(128);
    private final Multimap<AttachmentId, MessageId> messageIdsByAttachmentId = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    public AttachmentMetadata getAttachment(AttachmentId attachmentId) throws AttachmentNotFoundException {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        if (!this.attachmentsById.containsKey(attachmentId)) {
            throw new AttachmentNotFoundException(attachmentId.getId());
        }
        return this.attachmentsById.get(attachmentId);
    }

    public List<AttachmentMetadata> getAttachments(Collection<AttachmentId> attachmentIds) {
        Preconditions.checkArgument((attachmentIds != null ? 1 : 0) != 0);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AttachmentId attachmentId : attachmentIds) {
            if (!this.attachmentsById.containsKey(attachmentId)) continue;
            builder.add((Object)this.attachmentsById.get(attachmentId));
        }
        return builder.build();
    }

    public List<MessageAttachmentMetadata> storeAttachments(Collection<ParsedAttachment> parsedAttachments, MessageId ownerMessageId) throws MailboxException {
        return (List)parsedAttachments.stream().map(Throwing.function(typedContent -> this.storeAttachmentForMessage(ownerMessageId, (ParsedAttachment)typedContent)).sneakyThrow()).collect(ImmutableList.toImmutableList());
    }

    private MessageAttachmentMetadata storeAttachmentForMessage(MessageId ownerMessageId, ParsedAttachment parsedAttachment) throws MailboxException {
        MessageAttachmentMetadata messageAttachmentMetadata;
        block8: {
            StringBackedAttachmentId attachmentId = StringBackedAttachmentId.random();
            InputStream stream = parsedAttachment.getContent().openStream();
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)stream);
                this.attachmentsById.put((AttachmentId)attachmentId, AttachmentMetadata.builder().attachmentId((AttachmentId)attachmentId).messageId(ownerMessageId).type(parsedAttachment.getContentType()).size((long)bytes.length).build());
                this.attachmentsRawContentById.put((AttachmentId)attachmentId, bytes);
                this.messageIdsByAttachmentId.put((Object)attachmentId, (Object)ownerMessageId);
                messageAttachmentMetadata = parsedAttachment.asMessageAttachment((AttachmentId)attachmentId, (long)bytes.length, ownerMessageId);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return messageAttachmentMetadata;
    }

    public InputStream loadAttachmentContent(AttachmentId attachmentId) throws AttachmentNotFoundException, IOException {
        byte[] buf = this.attachmentsRawContentById.get(attachmentId);
        if (buf == null) {
            throw new AttachmentNotFoundException(attachmentId.toString());
        }
        return new ByteArrayInputStream(buf);
    }
}

