/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import com.unboundid.util.json.JSONValue;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONString
extends JSONValue {
    private static final long serialVersionUID = -4677194657299153890L;
    @Nullable
    private String jsonStringRepresentation;
    @NotNull
    private final String value;

    public JSONString(@NotNull String value) {
        this.value = value;
        this.jsonStringRepresentation = null;
    }

    JSONString(@NotNull String javaString, @NotNull String jsonString) {
        this.value = javaString;
        this.jsonStringRepresentation = jsonString;
    }

    @NotNull
    public String stringValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.stringValue().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JSONString) {
            JSONString s = (JSONString)o;
            return this.value.equals(s.value);
        }
        return false;
    }

    public boolean equals(@NotNull JSONString s, boolean ignoreCase) {
        if (ignoreCase) {
            return this.value.equalsIgnoreCase(s.value);
        }
        return this.value.equals(s.value);
    }

    @Override
    public boolean equals(@NotNull JSONValue v, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        return v instanceof JSONString && this.equals((JSONString)v, ignoreValueCase);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.jsonStringRepresentation == null) {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer);
            this.jsonStringRepresentation = buffer.toString();
        }
        return this.jsonStringRepresentation;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        if (this.jsonStringRepresentation != null) {
            buffer.append(this.jsonStringRepresentation);
        } else {
            boolean emptyBufferProvided = buffer.length() == 0;
            JSONString.encodeString(this.value, buffer);
            if (emptyBufferProvided) {
                this.jsonStringRepresentation = buffer.toString();
            }
        }
    }

    @Override
    @NotNull
    public String toSingleLineString() {
        return this.toString();
    }

    @Override
    public void toSingleLineString(@NotNull StringBuilder buffer) {
        this.toString(buffer);
    }

    static void encodeString(@NotNull String s, @NotNull StringBuilder buffer) {
        buffer.append('\"');
        block9: for (char c : s.toCharArray()) {
            switch (c) {
                case '\"': {
                    buffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                default: {
                    if (c <= '\u001f') {
                        buffer.append("\\u");
                        buffer.append(String.format("%04X", c));
                        continue block9;
                    }
                    buffer.append(c);
                }
            }
        }
        buffer.append('\"');
    }

    static void encodeString(@NotNull String s, @NotNull ByteStringBuffer buffer) {
        buffer.append('\"');
        block9: for (char c : s.toCharArray()) {
            switch (c) {
                case '\"': {
                    buffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                default: {
                    if (c <= '\u001f') {
                        buffer.append("\\u");
                        buffer.append(String.format("%04X", c));
                        continue block9;
                    }
                    buffer.append(c);
                }
            }
        }
        buffer.append('\"');
    }

    @Override
    @NotNull
    public String toNormalizedString() {
        StringBuilder buffer = new StringBuilder();
        this.toNormalizedString(buffer);
        return buffer.toString();
    }

    @Override
    public void toNormalizedString(@NotNull StringBuilder buffer) {
        this.toNormalizedString(buffer, false, true, false);
    }

    @Override
    @NotNull
    public String toNormalizedString(boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        StringBuilder buffer = new StringBuilder();
        this.toNormalizedString(buffer, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder);
        return buffer.toString();
    }

    @Override
    public void toNormalizedString(@NotNull StringBuilder buffer, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        buffer.append('\"');
        char[] charArray = ignoreValueCase ? StaticUtils.toLowerCase(this.value).toCharArray() : this.value.toCharArray();
        for (char c : charArray) {
            if (StaticUtils.isPrintable(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append("\\u");
            buffer.append(String.format("%04X", c));
        }
        buffer.append('\"');
    }

    @Override
    @NotNull
    public JSONString toNormalizedValue(boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        if (ignoreValueCase) {
            return new JSONString(StaticUtils.toLowerCase(this.value));
        }
        return this;
    }

    @Override
    public void appendToJSONBuffer(@NotNull JSONBuffer buffer) {
        buffer.appendString(this.value);
    }

    @Override
    public void appendToJSONBuffer(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.value);
    }
}

