/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JoinRule
implements Serializable {
    public static final byte JOIN_TYPE_AND = -96;
    public static final byte JOIN_TYPE_OR = -95;
    public static final byte JOIN_TYPE_DN = -126;
    public static final byte JOIN_TYPE_EQUALITY = -93;
    public static final byte JOIN_TYPE_CONTAINS = -92;
    public static final byte JOIN_TYPE_REVERSE_DN = -123;
    @NotNull
    private static final String JSON_FIELD_MATCH_ALL = "match-all";
    @NotNull
    private static final String JSON_FIELD_RULES = "rules";
    @NotNull
    private static final String JSON_FIELD_SOURCE_ATTRIBUTE = "source-attribute";
    @NotNull
    private static final String JSON_FIELD_TARGET_ATTRIBUTE = "target-attribute";
    @NotNull
    private static final String JSON_FIELD_TYPE = "type";
    @NotNull
    private static final String JSON_TYPE_AND = "and";
    @NotNull
    private static final String JSON_TYPE_CONTAINS = "contains";
    @NotNull
    private static final String JSON_TYPE_DN = "dn";
    @NotNull
    private static final String JSON_TYPE_EQUALITY = "equality";
    @NotNull
    private static final String JSON_TYPE_OR = "or";
    @NotNull
    private static final String JSON_TYPE_REVERSE_DN = "reverse-dn";
    @NotNull
    private static final JoinRule[] NO_RULES = new JoinRule[0];
    private static final long serialVersionUID = 9041070342511946580L;
    private final boolean matchAll;
    private final byte type;
    @NotNull
    private final JoinRule[] components;
    @Nullable
    private final String sourceAttribute;
    @Nullable
    private final String targetAttribute;

    private JoinRule(byte type, @NotNull JoinRule[] components, @Nullable String sourceAttribute, @Nullable String targetAttribute, boolean matchAll) {
        this.type = type;
        this.components = components;
        this.sourceAttribute = sourceAttribute;
        this.targetAttribute = targetAttribute;
        this.matchAll = matchAll;
    }

    @NotNull
    public static JoinRule createANDRule(JoinRule ... components) {
        Validator.ensureNotNull(components);
        Validator.ensureFalse(components.length == 0);
        return new JoinRule(-96, components, null, null, false);
    }

    @NotNull
    public static JoinRule createANDRule(@NotNull List<JoinRule> components) {
        Validator.ensureNotNull(components);
        Validator.ensureFalse(components.isEmpty());
        JoinRule[] compArray = new JoinRule[components.size()];
        return new JoinRule(-96, components.toArray(compArray), null, null, false);
    }

    @NotNull
    public static JoinRule createORRule(JoinRule ... components) {
        Validator.ensureNotNull(components);
        Validator.ensureFalse(components.length == 0);
        return new JoinRule(-95, components, null, null, false);
    }

    @NotNull
    public static JoinRule createORRule(@NotNull List<JoinRule> components) {
        Validator.ensureNotNull(components);
        Validator.ensureFalse(components.isEmpty());
        JoinRule[] compArray = new JoinRule[components.size()];
        return new JoinRule(-95, components.toArray(compArray), null, null, false);
    }

    @NotNull
    public static JoinRule createDNJoin(@NotNull String sourceAttribute) {
        Validator.ensureNotNull(sourceAttribute);
        return new JoinRule(-126, NO_RULES, sourceAttribute, null, false);
    }

    @NotNull
    public static JoinRule createEqualityJoin(@NotNull String sourceAttribute, @NotNull String targetAttribute, boolean matchAll) {
        Validator.ensureNotNull(sourceAttribute, targetAttribute);
        return new JoinRule(-93, NO_RULES, sourceAttribute, targetAttribute, matchAll);
    }

    @NotNull
    public static JoinRule createContainsJoin(@NotNull String sourceAttribute, @NotNull String targetAttribute, boolean matchAll) {
        Validator.ensureNotNull(sourceAttribute, targetAttribute);
        return new JoinRule(-92, NO_RULES, sourceAttribute, targetAttribute, matchAll);
    }

    @NotNull
    public static JoinRule createReverseDNJoin(@NotNull String targetAttribute) {
        Validator.ensureNotNull(targetAttribute);
        return new JoinRule(-123, NO_RULES, null, targetAttribute, false);
    }

    public byte getType() {
        return this.type;
    }

    @NotNull
    public JoinRule[] getComponents() {
        return this.components;
    }

    @Nullable
    public String getSourceAttribute() {
        return this.sourceAttribute;
    }

    @Nullable
    public String getTargetAttribute() {
        return this.targetAttribute;
    }

    public boolean matchAll() {
        return this.matchAll;
    }

    @NotNull
    ASN1Element encode() {
        switch (this.type) {
            case -96: 
            case -95: {
                ASN1Element[] compElements = new ASN1Element[this.components.length];
                for (int i = 0; i < this.components.length; ++i) {
                    compElements[i] = this.components[i].encode();
                }
                return new ASN1Set(this.type, compElements);
            }
            case -126: {
                return new ASN1OctetString(this.type, this.sourceAttribute);
            }
            case -93: 
            case -92: {
                if (this.matchAll) {
                    return new ASN1Sequence(this.type, new ASN1OctetString(this.sourceAttribute), new ASN1OctetString(this.targetAttribute), new ASN1Boolean(this.matchAll));
                }
                return new ASN1Sequence(this.type, new ASN1OctetString(this.sourceAttribute), new ASN1OctetString(this.targetAttribute));
            }
            case -123: {
                return new ASN1OctetString(this.type, this.targetAttribute);
            }
        }
        return null;
    }

    @NotNull
    static JoinRule decode(@NotNull ASN1Element element) throws LDAPException {
        byte elementType = element.getType();
        switch (elementType) {
            case -96: 
            case -95: {
                try {
                    ASN1Element[] elements = ASN1Set.decodeAsSet(element).elements();
                    JoinRule[] rules = new JoinRule[elements.length];
                    for (int i = 0; i < rules.length; ++i) {
                        rules[i] = JoinRule.decode(elements[i]);
                    }
                    return new JoinRule(elementType, rules, null, null, false);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            case -126: {
                return new JoinRule(elementType, NO_RULES, ASN1OctetString.decodeAsOctetString(element).stringValue(), null, false);
            }
            case -93: 
            case -92: {
                try {
                    ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
                    String sourceAttribute = elements[0].decodeAsOctetString().stringValue();
                    String targetAttribute = elements[1].decodeAsOctetString().stringValue();
                    boolean matchAll = false;
                    if (elements.length == 3) {
                        matchAll = elements[2].decodeAsBoolean().booleanValue();
                    }
                    return new JoinRule(elementType, NO_RULES, sourceAttribute, targetAttribute, matchAll);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            case -123: {
                return new JoinRule(elementType, NO_RULES, null, ASN1OctetString.decodeAsOctetString(element).stringValue(), false);
            }
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_DECODE_INVALID_TYPE.get(StaticUtils.toHex(elementType)));
    }

    @NotNull
    public JSONObject toJSON() {
        switch (this.type) {
            case -126: {
                return new JSONObject(new JSONField(JSON_FIELD_TYPE, JSON_TYPE_DN), new JSONField(JSON_FIELD_SOURCE_ATTRIBUTE, this.sourceAttribute));
            }
            case -123: {
                return new JSONObject(new JSONField(JSON_FIELD_TYPE, JSON_TYPE_REVERSE_DN), new JSONField(JSON_FIELD_TARGET_ATTRIBUTE, this.targetAttribute));
            }
            case -93: {
                return new JSONObject(new JSONField(JSON_FIELD_TYPE, JSON_TYPE_EQUALITY), new JSONField(JSON_FIELD_SOURCE_ATTRIBUTE, this.sourceAttribute), new JSONField(JSON_FIELD_TARGET_ATTRIBUTE, this.targetAttribute), new JSONField(JSON_FIELD_MATCH_ALL, this.matchAll));
            }
            case -92: {
                return new JSONObject(new JSONField(JSON_FIELD_TYPE, JSON_TYPE_CONTAINS), new JSONField(JSON_FIELD_SOURCE_ATTRIBUTE, this.sourceAttribute), new JSONField(JSON_FIELD_TARGET_ATTRIBUTE, this.targetAttribute), new JSONField(JSON_FIELD_MATCH_ALL, this.matchAll));
            }
            case -96: {
                ArrayList<JSONObject> andRuleValues = new ArrayList<JSONObject>(this.components.length);
                for (JoinRule rule : this.components) {
                    andRuleValues.add(rule.toJSON());
                }
                return new JSONObject(new JSONField(JSON_FIELD_TYPE, JSON_TYPE_AND), new JSONField(JSON_FIELD_RULES, new JSONArray(andRuleValues)));
            }
            case -95: {
                ArrayList<JSONObject> orRuleValues = new ArrayList<JSONObject>(this.components.length);
                for (JoinRule rule : this.components) {
                    orRuleValues.add(rule.toJSON());
                }
                return new JSONObject(new JSONField(JSON_FIELD_TYPE, JSON_TYPE_OR), new JSONField(JSON_FIELD_RULES, new JSONArray(orRuleValues)));
            }
        }
        return null;
    }

    @NotNull
    public static JoinRule decodeJSONJoinRule(@NotNull JSONObject o, boolean strict) throws LDAPException {
        String type = o.getFieldAsString(JSON_FIELD_TYPE);
        if (type == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_MISSING_TYPE.get(JSON_FIELD_TYPE));
        }
        switch (type) {
            case "dn": {
                return JoinRule.decodeJSONDNJoinRule(o, strict);
            }
            case "reverse-dn": {
                return JoinRule.decodeJSONReverseDNJoinRule(o, strict);
            }
            case "equality": {
                return JoinRule.decodeJSONEqualityJoinRule(o, strict);
            }
            case "contains": {
                return JoinRule.decodeJSONContainsJoinRule(o, strict);
            }
            case "and": {
                return JoinRule.decodeJSONANDJoinRule(o, strict);
            }
            case "or": {
                return JoinRule.decodeJSONORJoinRule(o, strict);
            }
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_UNRECOGNIZED_TYPE.get(type));
    }

    @NotNull
    private static JoinRule decodeJSONDNJoinRule(@NotNull JSONObject o, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        String sourceAttribute = o.getFieldAsString(JSON_FIELD_SOURCE_ATTRIBUTE);
        if (sourceAttribute == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_DN_MISSING_SOURCE_ATTR.get(JSON_FIELD_SOURCE_ATTRIBUTE));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(o, JSON_FIELD_TYPE, JSON_FIELD_SOURCE_ATTRIBUTE)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_UNRECOGNIZED_DN_FIELD.get(unrecognizedFields.get(0)));
        }
        return JoinRule.createDNJoin(sourceAttribute);
    }

    @NotNull
    private static JoinRule decodeJSONReverseDNJoinRule(@NotNull JSONObject o, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        String targetAttribute = o.getFieldAsString(JSON_FIELD_TARGET_ATTRIBUTE);
        if (targetAttribute == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_REVERSE_DN_MISSING_TARGET_ATTR.get(JSON_FIELD_TARGET_ATTRIBUTE));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(o, JSON_FIELD_TYPE, JSON_FIELD_TARGET_ATTRIBUTE)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_UNRECOGNIZED_REVERSE_DN_FIELD.get(unrecognizedFields.get(0)));
        }
        return JoinRule.createReverseDNJoin(targetAttribute);
    }

    @NotNull
    private static JoinRule decodeJSONEqualityJoinRule(@NotNull JSONObject o, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        String sourceAttribute = o.getFieldAsString(JSON_FIELD_SOURCE_ATTRIBUTE);
        if (sourceAttribute == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_EQUALITY_MISSING_FIELD.get(JSON_FIELD_SOURCE_ATTRIBUTE));
        }
        String targetAttribute = o.getFieldAsString(JSON_FIELD_TARGET_ATTRIBUTE);
        if (targetAttribute == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_EQUALITY_MISSING_FIELD.get(JSON_FIELD_TARGET_ATTRIBUTE));
        }
        Boolean matchAll = o.getFieldAsBoolean(JSON_FIELD_MATCH_ALL);
        if (matchAll == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_EQUALITY_MISSING_FIELD.get(JSON_FIELD_MATCH_ALL));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(o, JSON_FIELD_TYPE, JSON_FIELD_SOURCE_ATTRIBUTE, JSON_FIELD_TARGET_ATTRIBUTE, JSON_FIELD_MATCH_ALL)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_UNRECOGNIZED_EQUALITY_FIELD.get(unrecognizedFields.get(0)));
        }
        return JoinRule.createEqualityJoin(sourceAttribute, targetAttribute, matchAll);
    }

    @NotNull
    private static JoinRule decodeJSONContainsJoinRule(@NotNull JSONObject o, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        String sourceAttribute = o.getFieldAsString(JSON_FIELD_SOURCE_ATTRIBUTE);
        if (sourceAttribute == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_CONTAINS_MISSING_FIELD.get(JSON_FIELD_SOURCE_ATTRIBUTE));
        }
        String targetAttribute = o.getFieldAsString(JSON_FIELD_TARGET_ATTRIBUTE);
        if (targetAttribute == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_CONTAINS_MISSING_FIELD.get(JSON_FIELD_TARGET_ATTRIBUTE));
        }
        Boolean matchAll = o.getFieldAsBoolean(JSON_FIELD_MATCH_ALL);
        if (matchAll == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_CONTAINS_MISSING_FIELD.get(JSON_FIELD_MATCH_ALL));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(o, JSON_FIELD_TYPE, JSON_FIELD_SOURCE_ATTRIBUTE, JSON_FIELD_TARGET_ATTRIBUTE, JSON_FIELD_MATCH_ALL)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_UNRECOGNIZED_CONTAINS_FIELD.get(unrecognizedFields.get(0)));
        }
        return JoinRule.createContainsJoin(sourceAttribute, targetAttribute, matchAll);
    }

    @NotNull
    private static JoinRule decodeJSONANDJoinRule(@NotNull JSONObject o, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        List<JSONValue> ruleValues = o.getFieldAsArray(JSON_FIELD_RULES);
        if (ruleValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_AND_MISSING_RULES.get(JSON_FIELD_RULES));
        }
        if (ruleValues.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_AND_EMPTY_RULES.get(JSON_FIELD_RULES));
        }
        ArrayList<JoinRule> rules = new ArrayList<JoinRule>(ruleValues.size());
        for (JSONValue v : ruleValues) {
            if (v instanceof JSONObject) {
                rules.add(JoinRule.decodeJSONJoinRule((JSONObject)v, strict));
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_AND_RULE_NOT_OBJECT.get(JSON_FIELD_RULES));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(o, JSON_FIELD_TYPE, JSON_FIELD_RULES)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_UNRECOGNIZED_AND_FIELD.get(unrecognizedFields.get(0)));
        }
        return JoinRule.createANDRule(rules);
    }

    @NotNull
    private static JoinRule decodeJSONORJoinRule(@NotNull JSONObject o, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        List<JSONValue> ruleValues = o.getFieldAsArray(JSON_FIELD_RULES);
        if (ruleValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_OR_MISSING_RULES.get(JSON_FIELD_RULES));
        }
        if (ruleValues.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_OR_EMPTY_RULES.get(JSON_FIELD_RULES));
        }
        ArrayList<JoinRule> rules = new ArrayList<JoinRule>(ruleValues.size());
        for (JSONValue v : ruleValues) {
            if (v instanceof JSONObject) {
                rules.add(JoinRule.decodeJSONJoinRule((JSONObject)v, strict));
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_OR_RULE_NOT_OBJECT.get(JSON_FIELD_RULES));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(o, JSON_FIELD_TYPE, JSON_FIELD_RULES)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RULE_JSON_UNRECOGNIZED_OR_FIELD.get(unrecognizedFields.get(0)));
        }
        return JoinRule.createORRule(rules);
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        switch (this.type) {
            case -96: {
                buffer.append("ANDJoinRule(components={");
                for (int i = 0; i < this.components.length; ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    this.components[i].toString(buffer);
                }
                buffer.append("})");
                break;
            }
            case -95: {
                buffer.append("ORJoinRule(components={");
                for (int i = 0; i < this.components.length; ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    this.components[i].toString(buffer);
                }
                buffer.append("})");
                break;
            }
            case -126: {
                buffer.append("DNJoinRule(sourceAttr=");
                buffer.append(this.sourceAttribute);
                buffer.append(')');
                break;
            }
            case -93: {
                buffer.append("EqualityJoinRule(sourceAttr=");
                buffer.append(this.sourceAttribute);
                buffer.append(", targetAttr=");
                buffer.append(this.targetAttribute);
                buffer.append(", matchAll=");
                buffer.append(this.matchAll);
                buffer.append(')');
                break;
            }
            case -92: {
                buffer.append("ContainsJoinRule(sourceAttr=");
                buffer.append(this.sourceAttribute);
                buffer.append(", targetAttr=");
                buffer.append(this.targetAttribute);
                buffer.append(", matchAll=");
                buffer.append(this.matchAll);
                buffer.append(')');
                break;
            }
            case -123: {
                buffer.append("ReverseDNJoinRule(targetAttr=");
                buffer.append(this.targetAttribute);
                buffer.append(')');
            }
        }
    }
}

