/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LockdownModeLDAPConnectionPoolHealthCheck
extends LDAPConnectionPoolHealthCheck
implements Serializable {
    private static final long DEFAULT_MAX_RESPONSE_TIME_MILLIS = 5000L;
    @NotNull
    private static final String IS_IN_LOCKDOWN_MODE_ATTRIBUTE_NAME = "is-in-lockdown-mode";
    @NotNull
    private static final String STATUS_HEALTH_SUMMARY_MONITOR_ENTRY_DN = "cn=Status Health Summary,cn=monitor";
    private static final long serialVersionUID = 11911667291461474L;
    private final boolean invokeAfterAuthentication;
    private final boolean invokeForBackgroundChecks;
    private final boolean invokeOnCheckout;
    private final boolean invokeOnCreate;
    private final boolean invokeOnException;
    private final boolean invokeOnRelease;
    private final long maxResponseTimeMillis;
    @NotNull
    private final SearchRequest searchRequest;

    public LockdownModeLDAPConnectionPoolHealthCheck(boolean invokeOnCreate, boolean invokeAfterAuthentication, boolean invokeOnCheckout, boolean invokeOnRelease, boolean invokeForBackgroundChecks, boolean invokeOnException, long maxResponseTimeMillis) {
        this.invokeOnCreate = invokeOnCreate;
        this.invokeAfterAuthentication = invokeAfterAuthentication;
        this.invokeOnCheckout = invokeOnCheckout;
        this.invokeOnRelease = invokeOnRelease;
        this.invokeForBackgroundChecks = invokeForBackgroundChecks;
        this.invokeOnException = invokeOnException;
        this.maxResponseTimeMillis = maxResponseTimeMillis > 0L ? maxResponseTimeMillis : 5000L;
        int timeLimitSeconds = (int)(this.maxResponseTimeMillis / 1000L);
        if (this.maxResponseTimeMillis % 1000L != 0L) {
            ++timeLimitSeconds;
        }
        this.searchRequest = new SearchRequest(STATUS_HEALTH_SUMMARY_MONITOR_ENTRY_DN, SearchScope.BASE, DereferencePolicy.NEVER, 1, timeLimitSeconds, false, Filter.createANDFilter(new Filter[0]), IS_IN_LOCKDOWN_MODE_ATTRIBUTE_NAME);
        this.searchRequest.setResponseTimeoutMillis(this.maxResponseTimeMillis);
    }

    @Override
    public void ensureNewConnectionValid(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeOnCreate) {
            this.checkForLockdownMode(connection);
        }
    }

    @Override
    public void ensureConnectionValidAfterAuthentication(@NotNull LDAPConnection connection, @NotNull BindResult bindResult) throws LDAPException {
        if (this.invokeAfterAuthentication && bindResult.getResultCode() == ResultCode.SUCCESS) {
            this.checkForLockdownMode(connection);
        }
    }

    @Override
    public void ensureConnectionValidForCheckout(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeOnCheckout) {
            this.checkForLockdownMode(connection);
        }
    }

    @Override
    public void ensureConnectionValidForRelease(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeOnRelease) {
            this.checkForLockdownMode(connection);
        }
    }

    @Override
    public void ensureConnectionValidForContinuedUse(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeForBackgroundChecks) {
            this.checkForLockdownMode(connection);
        }
    }

    @Override
    public void ensureConnectionValidAfterException(@NotNull LDAPConnection connection, @NotNull LDAPException exception) throws LDAPException {
        if (this.invokeOnException && !ResultCode.isConnectionUsable(exception.getResultCode())) {
            this.checkForLockdownMode(connection);
        }
    }

    public boolean invokeOnCreate() {
        return this.invokeOnCreate;
    }

    public boolean invokeAfterAuthentication() {
        return this.invokeAfterAuthentication;
    }

    public boolean invokeOnCheckout() {
        return this.invokeOnCheckout;
    }

    public boolean invokeOnRelease() {
        return this.invokeOnRelease;
    }

    public boolean invokeForBackgroundChecks() {
        return this.invokeForBackgroundChecks;
    }

    public boolean invokeOnException() {
        return this.invokeOnException;
    }

    public long getMaxResponseTimeMillis() {
        return this.maxResponseTimeMillis;
    }

    private void checkForLockdownMode(@NotNull LDAPConnection conn) throws LDAPException {
        SearchResultEntry monitorEntry;
        try {
            monitorEntry = conn.searchForEntry(this.searchRequest.duplicate());
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            String message = UnboundIDDSMessages.ERR_LOCKDOWN_MODE_HEALTH_CHECK_ERROR_GETTING_MONITOR_ENTRY.get(STATUS_HEALTH_SUMMARY_MONITOR_ENTRY_DN, conn.getHostPort(), StaticUtils.getExceptionMessage(e));
            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, message, e);
            throw new LDAPException(e.getResultCode(), message, e);
        }
        if (monitorEntry == null) {
            String message = UnboundIDDSMessages.ERR_LOCKDOWN_MODE_HEALTH_CHECK_NO_MONITOR_ENTRY.get(STATUS_HEALTH_SUMMARY_MONITOR_ENTRY_DN, conn.getHostPort());
            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, message, null);
            throw new LDAPException(ResultCode.NO_RESULTS_RETURNED, message);
        }
        Boolean isInLockdownMode = monitorEntry.getAttributeValueAsBoolean(IS_IN_LOCKDOWN_MODE_ATTRIBUTE_NAME);
        if (isInLockdownMode == null) {
            String message = UnboundIDDSMessages.ERR_LOCKDOWN_MODE_HEALTH_CHECK_NO_MONITOR_ATTR.get(STATUS_HEALTH_SUMMARY_MONITOR_ENTRY_DN, conn.getHostPort(), IS_IN_LOCKDOWN_MODE_ATTRIBUTE_NAME);
            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, message, null);
            throw new LDAPException(ResultCode.NO_SUCH_ATTRIBUTE, message);
        }
        if (Boolean.TRUE.equals(isInLockdownMode)) {
            String message = UnboundIDDSMessages.ERR_LOCKDOWN_MODE_HEALTH_CHECK_IS_IN_LOCKDOWN_MODE.get(conn.getHostPort());
            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, message, null);
            throw new LDAPException(ResultCode.UNAVAILABLE, message);
        }
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("LockdownMOdeLDAPConnectionPoolHealthCheck(invokeOnCreate=");
        buffer.append(this.invokeOnCreate);
        buffer.append(", invokeAfterAuthentication=");
        buffer.append(this.invokeAfterAuthentication);
        buffer.append(", invokeOnCheckout=");
        buffer.append(this.invokeOnCheckout);
        buffer.append(", invokeOnRelease=");
        buffer.append(this.invokeOnRelease);
        buffer.append(", invokeForBackgroundChecks=");
        buffer.append(this.invokeForBackgroundChecks);
        buffer.append(", invokeOnException=");
        buffer.append(this.invokeOnException);
        buffer.append(", maxResponseTimeMillis=");
        buffer.append(this.maxResponseTimeMillis);
        buffer.append(')');
    }
}

