/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ResultCodeCounter;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class SearchRateAsyncListener
implements AsyncSearchResultListener {
    private static final long serialVersionUID = 4929527281011834420L;
    @NotNull
    private final AtomicLong entryCounter;
    @NotNull
    private final AtomicLong errorCounter;
    @NotNull
    private final AtomicLong searchCounter;
    @NotNull
    private final AtomicLong searchDurations;
    @NotNull
    private final AtomicReference<ResultCode> resultCode;
    private final long startTime;
    @NotNull
    private final ResultCodeCounter rcCounter;
    @Nullable
    private final Semaphore asyncSemaphore;

    SearchRateAsyncListener(@NotNull AtomicLong searchCounter, @NotNull AtomicLong entryCounter, @NotNull AtomicLong searchDurations, @NotNull AtomicLong errorCounter, @NotNull ResultCodeCounter rcCounter, @Nullable Semaphore asyncSemaphore, @NotNull AtomicReference<ResultCode> resultCode) {
        this.searchCounter = searchCounter;
        this.entryCounter = entryCounter;
        this.searchDurations = searchDurations;
        this.errorCounter = errorCounter;
        this.rcCounter = rcCounter;
        this.asyncSemaphore = asyncSemaphore;
        this.resultCode = resultCode;
        this.startTime = System.nanoTime();
    }

    @Override
    public void searchEntryReturned(@NotNull SearchResultEntry searchEntry) {
    }

    @Override
    public void searchReferenceReturned(@NotNull SearchResultReference searchReference) {
    }

    @Override
    public void searchResultReceived(@NotNull AsyncRequestID requestID, @NotNull SearchResult searchResult) {
        this.searchDurations.addAndGet(System.nanoTime() - this.startTime);
        if (this.asyncSemaphore != null) {
            this.asyncSemaphore.release();
        }
        this.searchCounter.incrementAndGet();
        this.entryCounter.addAndGet(searchResult.getEntryCount());
        ResultCode rc = searchResult.getResultCode();
        if (rc != ResultCode.SUCCESS) {
            this.errorCounter.incrementAndGet();
            this.rcCounter.increment(rc);
            this.resultCode.compareAndSet(null, rc);
        }
    }
}

