/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.sdk.ConnectThread;
import com.unboundid.ldap.sdk.DisconnectInfo;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionLogger;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionReader;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.WriteTimeoutHandler;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.sasl.SaslClient;

@InternalUseOnly
final class LDAPConnectionInternals {
    @NotNull
    private static final AtomicLong ACTIVE_CONNECTION_COUNT = new AtomicLong(0L);
    @NotNull
    private static final AtomicReference<ThreadLocal<ASN1Buffer>> ASN1_BUFFERS = new AtomicReference(new ThreadLocal());
    @NotNull
    private final AtomicInteger nextMessageID;
    private final boolean synchronousMode;
    @NotNull
    private final InetAddress inetAddress;
    private final int port;
    private final long connectTime;
    @NotNull
    private final LDAPConnection connection;
    @Nullable
    private final LDAPConnectionReader connectionReader;
    @Nullable
    private volatile OutputStream outputStream;
    @Nullable
    private volatile SaslClient saslClient;
    @Nullable
    private volatile Socket socket;
    @NotNull
    private final String host;
    @NotNull
    private final WriteTimeoutHandler writeTimeoutHandler;

    LDAPConnectionInternals(@NotNull LDAPConnection connection, @NotNull LDAPConnectionOptions options, @NotNull SocketFactory socketFactory, @NotNull String host, @NotNull InetAddress inetAddress, int port, int timeout) throws IOException {
        this.connection = connection;
        this.host = host;
        this.inetAddress = inetAddress;
        this.port = port;
        if (options.captureConnectStackTrace()) {
            connection.setConnectStackTrace(Thread.currentThread().getStackTrace());
        }
        this.connectTime = System.currentTimeMillis();
        this.nextMessageID = new AtomicInteger(0);
        this.synchronousMode = options.useSynchronousMode();
        this.saslClient = null;
        this.socket = null;
        this.writeTimeoutHandler = new WriteTimeoutHandler(connection);
        try {
            ConnectThread connectThread = new ConnectThread(socketFactory, inetAddress, port, timeout);
            connectThread.start();
            this.socket = connectThread.getConnectedSocket();
            if (this.socket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)this.socket;
                options.getSSLSocketVerifier().verifySSLSocket(host, port, sslSocket);
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            if (this.socket != null) {
                this.socket.close();
            }
            this.writeTimeoutHandler.destroy();
            throw new IOException(le);
        }
        try {
            Debug.debugConnect(host, port, connection);
            LDAPConnectionLogger logger = options.getConnectionLogger();
            if (logger != null) {
                logger.logConnect(connection, host, inetAddress, port);
            }
            if (options.getReceiveBufferSize() > 0) {
                this.socket.setReceiveBufferSize(options.getReceiveBufferSize());
            }
            if (options.getSendBufferSize() > 0) {
                this.socket.setSendBufferSize(options.getSendBufferSize());
            }
            this.socket.setKeepAlive(options.useKeepAlive());
            this.socket.setReuseAddress(options.useReuseAddress());
            this.socket.setSoLinger(options.useLinger(), options.getLingerTimeoutSeconds());
            this.socket.setTcpNoDelay(options.useTCPNoDelay());
            int soTimeout = Math.max(0, (int)options.getResponseTimeoutMillis());
            Debug.debug(Level.INFO, DebugType.CONNECT, "Setting the SO_TIMEOUT value for connection " + connection + " to " + soTimeout + "ms.");
            this.socket.setSoTimeout(soTimeout);
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.connectionReader = new LDAPConnectionReader(connection, this);
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            try {
                this.socket.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            this.writeTimeoutHandler.destroy();
            throw ioe;
        }
        ACTIVE_CONNECTION_COUNT.incrementAndGet();
    }

    void startConnectionReader() {
        if (!this.synchronousMode) {
            this.connectionReader.start();
        }
    }

    @NotNull
    LDAPConnection getConnection() {
        return this.connection;
    }

    @Nullable
    LDAPConnectionReader getConnectionReader() {
        return this.connectionReader;
    }

    @NotNull
    InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @NotNull
    String getHost() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    @Nullable
    Socket getSocket() {
        return this.socket;
    }

    void setSocket(@NotNull Socket socket) {
        this.socket = socket;
    }

    @Nullable
    OutputStream getOutputStream() {
        return this.outputStream;
    }

    boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    boolean synchronousMode() {
        return this.synchronousMode;
    }

    void convertToTLS(@NotNull SSLSocketFactory sslSocketFactory) throws LDAPException {
        this.outputStream = this.connectionReader.doStartTLS(sslSocketFactory);
    }

    void applySASLQoP(@NotNull SaslClient saslClient) throws LDAPException {
        this.saslClient = saslClient;
        this.connectionReader.applySASLQoP(saslClient);
    }

    int nextMessageID() {
        int msgID = this.nextMessageID.incrementAndGet();
        if (msgID > 0) {
            return msgID;
        }
        do {
            if (!this.nextMessageID.compareAndSet(msgID, 1)) continue;
            return 1;
        } while ((msgID = this.nextMessageID.incrementAndGet()) <= 0);
        return msgID;
    }

    void registerResponseAcceptor(int messageID, @NotNull ResponseAcceptor responseAcceptor) throws LDAPException {
        if (!this.isConnected()) {
            LDAPConnectionOptions connectionOptions = this.connection.getConnectionOptions();
            boolean autoReconnect = connectionOptions.autoReconnect();
            boolean closeRequested = this.connection.closeRequested();
            if (autoReconnect && !closeRequested) {
                this.connection.reconnect();
                this.connection.registerResponseAcceptor(messageID, responseAcceptor);
            } else {
                throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
            }
        }
        this.connectionReader.registerResponseAcceptor(messageID, responseAcceptor);
    }

    void deregisterResponseAcceptor(int messageID) {
        this.connectionReader.deregisterResponseAcceptor(messageID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void sendMessage(@NotNull LDAPMessage message, long sendTimeoutMillis, boolean allowRetry) throws LDAPException {
        OutputStream os;
        block28: {
            ASN1Buffer buffer;
            block27: {
                boolean closeRequested;
                if (!this.isConnected()) {
                    throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_NOT_ESTABLISHED.get());
                }
                buffer = ASN1_BUFFERS.get().get();
                if (buffer == null) {
                    buffer = new ASN1Buffer();
                    ASN1_BUFFERS.get().set(buffer);
                }
                buffer.clear();
                try {
                    message.writeTo(buffer);
                }
                catch (LDAPRuntimeException lre) {
                    Debug.debugException(lre);
                    lre.throwLDAPException();
                }
                try {
                    int soTimeout = Math.max(0, (int)sendTimeoutMillis);
                    if (Debug.debugEnabled()) {
                        Debug.debug(Level.INFO, DebugType.CONNECT, "Setting the SO_TIMEOUT value for connection " + this.connection + " to " + soTimeout + "ms.");
                    }
                    this.socket.setSoTimeout(soTimeout);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                Long writeID = sendTimeoutMillis > 0L ? Long.valueOf(this.writeTimeoutHandler.beginWrite(sendTimeoutMillis)) : null;
                try {
                    os = this.outputStream;
                    if (os == null) {
                        if (message.getProtocolOpType() == 66) {
                            return;
                        }
                        closeRequested = this.connection.closeRequested();
                        if (!allowRetry || closeRequested || this.connection.synchronousMode()) throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_SEND_ERROR_NOT_ESTABLISHED.get(this.host, this.port));
                        this.connection.reconnect();
                        try {
                            this.sendMessage(message, sendTimeoutMillis, false);
                            return;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_SEND_ERROR_NOT_ESTABLISHED.get(this.host, this.port));
                        }
                    }
                    if (this.saslClient != null) break block27;
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    throw e;
                }
                catch (IOException ioe) {
                    Debug.debugException(ioe);
                    if (message.getProtocolOpType() == 66) {
                        return;
                    }
                    closeRequested = this.connection.closeRequested();
                    if (!allowRetry || closeRequested || this.connection.synchronousMode()) throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_SEND_ERROR.get(this.host + ':' + this.port, StaticUtils.getExceptionMessage(ioe)), ioe);
                    this.connection.reconnect();
                    try {
                        this.sendMessage(message, sendTimeoutMillis, false);
                        return;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_SEND_ERROR.get(this.host + ':' + this.port, StaticUtils.getExceptionMessage(ioe)), ioe);
                    }
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONN_ENCODE_ERROR.get(this.host + ':' + this.port, StaticUtils.getExceptionMessage(e)), e);
                }
                finally {
                    if (writeID != null) {
                        this.writeTimeoutHandler.writeCompleted(writeID);
                    }
                    if (buffer.zeroBufferOnClear()) {
                        buffer.clear();
                    }
                }
                buffer.writeTo(os);
                break block28;
            }
            byte[] clearBytes = buffer.toByteArray();
            byte[] saslBytes = this.saslClient.wrap(clearBytes, 0, clearBytes.length);
            byte[] lengthBytes = new byte[]{(byte)(saslBytes.length >> 24 & 0xFF), (byte)(saslBytes.length >> 16 & 0xFF), (byte)(saslBytes.length >> 8 & 0xFF), (byte)(saslBytes.length & 0xFF)};
            os.write(lengthBytes);
            os.write(saslBytes);
        }
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        boolean alreadyClosed;
        DisconnectInfo disconnectInfo = this.connection.getDisconnectInfo();
        if (disconnectInfo == null) {
            disconnectInfo = this.connection.setDisconnectInfo(new DisconnectInfo(this.connection, DisconnectType.UNKNOWN, null, null));
        }
        boolean closedByFinalizer = disconnectInfo.getType() == DisconnectType.CLOSED_BY_FINALIZER && this.socket != null && this.socket.isConnected();
        this.writeTimeoutHandler.destroy();
        if (this.socket == null) {
            alreadyClosed = true;
        } else {
            alreadyClosed = false;
            try {
                try {
                    this.outputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            finally {
                this.outputStream = null;
                this.socket = null;
            }
            try {
                this.connectionReader.close(false);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        if (this.saslClient != null) {
            try {
                this.saslClient.dispose();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            finally {
                this.saslClient = null;
            }
        }
        if (!alreadyClosed) {
            Debug.debugDisconnect(this.host, this.port, this.connection, disconnectInfo.getType(), disconnectInfo.getMessage(), disconnectInfo.getCause());
            LDAPConnectionLogger logger = this.connection.getConnectionOptions().getConnectionLogger();
            if (logger != null) {
                logger.logDisconnect(this.connection, this.host, this.port, disconnectInfo.getType(), disconnectInfo.getMessage(), disconnectInfo.getCause());
            }
        }
        if (closedByFinalizer && Debug.debugEnabled(DebugType.LDAP)) {
            Debug.debug(Level.WARNING, DebugType.LDAP, "Connection closed by LDAP SDK finalizer:  " + this.toString());
        }
        disconnectInfo.notifyDisconnectHandler();
        this.connection.setServerSet(null);
        long remainingActiveConnections = ACTIVE_CONNECTION_COUNT.decrementAndGet();
        if (remainingActiveConnections <= 0L) {
            ASN1_BUFFERS.set(new ThreadLocal());
            if (remainingActiveConnections < 0L) {
                ACTIVE_CONNECTION_COUNT.compareAndSet(remainingActiveConnections, 0L);
            }
        }
    }

    public long getConnectTime() {
        if (this.isConnected()) {
            return this.connectTime;
        }
        return -1L;
    }

    static long getActiveConnectionCount() {
        return ACTIVE_CONNECTION_COUNT.get();
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("LDAPConnectionInternals(host='");
        buffer.append(this.host);
        buffer.append("', port=");
        buffer.append(this.port);
        buffer.append(", connected=");
        buffer.append(this.socket != null && this.socket.isConnected());
        buffer.append(", nextMessageID=");
        buffer.append(this.nextMessageID.get());
        buffer.append(')');
    }
}

