/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.term;

import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.ArithmeticOperator;
import com.datastax.oss.driver.internal.querybuilder.term.ArithmeticTerm;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;

@Immutable
public class OppositeTerm
extends ArithmeticTerm {
    @NonNull
    private final Term argument;

    public OppositeTerm(@NonNull Term argument) {
        super(ArithmeticOperator.OPPOSITE);
        Preconditions.checkNotNull((Object)argument);
        this.argument = argument;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        builder.append('-');
        OppositeTerm.appendAndMaybeParenthesize(this.operator.getPrecedenceLeft(), this.argument, builder);
    }

    @Override
    public boolean isIdempotent() {
        return this.argument.isIdempotent();
    }

    @NonNull
    public Term getArgument() {
        return this.argument;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof OppositeTerm) {
            OppositeTerm that = (OppositeTerm)other;
            return this.argument.equals(that.argument);
        }
        return false;
    }

    public int hashCode() {
        return this.argument.hashCode();
    }
}

