/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.change;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.stream.Collector;
import org.apache.james.jmap.api.change.Limit;
import org.apache.james.jmap.api.change.MailboxChange;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.change.MailboxChanges;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.exception.ChangeNotFoundException;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.cassandra.change.MailboxChangeRepositoryDAO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailboxChangeRepository
implements MailboxChangeRepository {
    public static final String LIMIT_NAME = "mailboxChangeDefaultLimit";
    private final MailboxChangeRepositoryDAO mailboxChangeRepositoryDAO;
    private final Limit defaultLimit;

    @Inject
    public CassandraMailboxChangeRepository(MailboxChangeRepositoryDAO mailboxChangeRepositoryDAO, @Named(value="mailboxChangeDefaultLimit") Limit defaultLimit) {
        this.mailboxChangeRepositoryDAO = mailboxChangeRepositoryDAO;
        this.defaultLimit = defaultLimit;
    }

    public Mono<Void> save(MailboxChange change) {
        return this.mailboxChangeRepositoryDAO.insert(change);
    }

    public Mono<MailboxChanges> getSinceState(AccountId accountId, State state, Optional<Limit> maxChanges) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)state);
        maxChanges.ifPresent(limit -> Preconditions.checkArgument((limit.getValue() > 0 ? 1 : 0) != 0, (Object)"maxChanges must be a positive integer"));
        if (state.equals((Object)State.INITIAL)) {
            return this.mailboxChangeRepositoryDAO.getAllChanges(accountId).filter(change -> !change.isShared()).collect((Collector)new MailboxChanges.MailboxChangesBuilder.MailboxChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
        }
        return this.mailboxChangeRepositoryDAO.getChangesSince(accountId, state).switchIfEmpty((Publisher)Flux.error(() -> new ChangeNotFoundException(state, String.format("State '%s' could not be found", state.getValue())))).filter(change -> !change.isShared()).filter(change -> !change.getState().equals((Object)state)).collect((Collector)new MailboxChanges.MailboxChangesBuilder.MailboxChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
    }

    public Mono<MailboxChanges> getSinceStateWithDelegation(AccountId accountId, State state, Optional<Limit> maxChanges) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)state);
        maxChanges.ifPresent(limit -> Preconditions.checkArgument((limit.getValue() > 0 ? 1 : 0) != 0, (Object)"maxChanges must be a positive integer"));
        if (state.equals((Object)State.INITIAL)) {
            return this.mailboxChangeRepositoryDAO.getAllChanges(accountId).collect((Collector)new MailboxChanges.MailboxChangesBuilder.MailboxChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
        }
        return this.mailboxChangeRepositoryDAO.getChangesSince(accountId, state).switchIfEmpty((Publisher)Flux.error(() -> new ChangeNotFoundException(state, String.format("State '%s' could not be found", state.getValue())))).filter(change -> !change.getState().equals((Object)state)).collect((Collector)new MailboxChanges.MailboxChangesBuilder.MailboxChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
    }

    public Mono<State> getLatestState(AccountId accountId) {
        return this.mailboxChangeRepositoryDAO.latestStateNotDelegated(accountId).switchIfEmpty(Mono.just((Object)State.INITIAL));
    }

    public Mono<State> getLatestStateWithDelegation(AccountId accountId) {
        return this.mailboxChangeRepositoryDAO.latestState(accountId).switchIfEmpty(Mono.just((Object)State.INITIAL));
    }
}

