/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.memory;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import org.apache.james.core.Username;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MemoryDelegationStore
implements DelegationStore {
    private final Multimap<Username, Username> delegations = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    public Publisher<Username> authorizedUsers(Username baseUser) {
        return Flux.fromIterable((Iterable)this.delegations.get((Object)baseUser)).distinct();
    }

    public Publisher<Void> addAuthorizedUser(Username baseUser, Username userWithAccess) {
        return Mono.fromRunnable(() -> this.delegations.put((Object)baseUser, (Object)userWithAccess));
    }

    public Publisher<Void> removeAuthorizedUser(Username baseUser, Username userWithAccess) {
        return Mono.fromRunnable(() -> this.delegations.remove((Object)baseUser, (Object)userWithAccess));
    }

    public Publisher<Username> delegatedUsers(Username baseUser) {
        return Flux.fromIterable((Iterable)this.delegations.entries()).filter(entry -> ((Username)entry.getValue()).equals((Object)baseUser)).map(Map.Entry::getKey).distinct();
    }

    public Publisher<Void> removeDelegatedUser(Username baseUser, Username delegatedToUser) {
        return Mono.fromRunnable(() -> this.delegations.remove((Object)delegatedToUser, (Object)baseUser));
    }

    public Publisher<Void> clear(Username baseUser) {
        return Mono.fromRunnable(() -> this.delegations.removeAll((Object)baseUser));
    }
}

