/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.dsn;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.mailet.DsnParameters;

public class DSNRcptParameterHook
implements RcptHook {
    public static final ProtocolSession.AttachmentKey<Builder> DSN_RCPT_PARAMETERS = ProtocolSession.AttachmentKey.of((String)"DSN_RCPT_PARAMETERS", Builder.class);

    public Set<String> supportedParameters() {
        return ImmutableSet.of((Object)"ORCPT", (Object)"NOTIFY");
    }

    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt, Map<String, String> parameters) {
        Builder builder = session.getAttachment(DSN_RCPT_PARAMETERS, ProtocolSession.State.Transaction).orElse(new Builder());
        DsnParameters.RecipientDsnParameters.fromSMTPArgLine(parameters).ifPresent(rcptParameters -> session.setAttachment(DSN_RCPT_PARAMETERS, (Object)builder.add(rcpt, (DsnParameters.RecipientDsnParameters)rcptParameters), ProtocolSession.State.Transaction));
        return HookResult.DECLINED;
    }

    public static class Builder {
        private final ImmutableMap.Builder<MailAddress, DsnParameters.RecipientDsnParameters> entries = ImmutableMap.builder();

        public Builder add(MailAddress recipient, DsnParameters.RecipientDsnParameters parameters) {
            this.entries.put((Object)recipient, (Object)parameters);
            return this;
        }

        public ImmutableMap<MailAddress, DsnParameters.RecipientDsnParameters> build() {
            return this.entries.build();
        }
    }
}

