/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.pushsubscription;

import com.google.common.annotations.VisibleForTesting;
import eu.timepit.refined.api.Refined;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionHelpers;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.jmap.change.EmailDeliveryTypeName$;
import org.apache.james.jmap.change.StateChangeEvent;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.json.PushSerializer;
import org.apache.james.jmap.pushsubscription.Aes128gcm$;
import org.apache.james.jmap.pushsubscription.High$;
import org.apache.james.jmap.pushsubscription.Low$;
import org.apache.james.jmap.pushsubscription.PushListener$;
import org.apache.james.jmap.pushsubscription.PushListenerGroup;
import org.apache.james.jmap.pushsubscription.PushRequest;
import org.apache.james.jmap.pushsubscription.PushTTL$;
import org.apache.james.jmap.pushsubscription.PushUrgency;
import org.apache.james.jmap.pushsubscription.WebPushClient;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import play.api.libs.json.Json$;
import reactor.core.scala.publisher.MapablePublisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scala.publisher.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%w!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\"\u0002\u0016\u0002\t\u0003Yc\u0001\u0002\u0011\u0014\u0001UC\u0001\"\u001b\u0003\u0003\u0002\u0003\u0006IA\u001b\u0005\tc\u0012\u0011\t\u0011)A\u0005e\"AQ\u000f\u0002B\u0001B\u0003%a\u000f\u0003\u0005}\t\t\u0005\t\u0015!\u0003~\u0011)\tI\u0001\u0002B\u0001B\u0003%\u00111\u0002\u0005\u0007Q\u0011!\t!a\u0006\t\u000f\u0005]B\u0001\"\u0011\u0002:!9\u00111\t\u0003\u0005B\u0005\u0015\u0003bBA2\t\u0011\u0005\u0013Q\r\u0005\b\u0003_\"A\u0011BA9\u0011\u001d\tY\n\u0002C\u0005\u0003;Cq!!+\u0005\t\u0013\tY\u000bC\u0004\u0002>\u0012!I!a0\u0002\u0019A+8\u000f\u001b'jgR,g.\u001a:\u000b\u0005Q)\u0012\u0001\u00059vg\"\u001cXOY:de&\u0004H/[8o\u0015\t1r#\u0001\u0003k[\u0006\u0004(B\u0001\r\u001a\u0003\u0015Q\u0017-\\3t\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001A\u0011q$A\u0007\u0002'\ta\u0001+^:i\u0019&\u001cH/\u001a8feN\u0011\u0011A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q\u0012\u0001D3yiJ\f7\r\u001e+pa&\u001cGC\u0001\u0017A!\tiSH\u0004\u0002/w9\u0011qF\u000f\b\u0003aer!!\r\u001d\u000f\u0005I:dBA\u001a7\u001b\u0005!$BA\u001b\u001e\u0003\u0019a$o\\8u}%\tA$\u0003\u0002\u001b7%\u0011\u0001$G\u0005\u0003-]I!\u0001F\u000b\n\u0005q\u001a\u0012!\u0003)vg\"$v\u000e]5d\u0013\tqtHA\u0005QkNDGk\u001c9jG*\u0011Ah\u0005\u0005\u0006\u0003\u000e\u0001\rAQ\u0001\fgR\fG/Z\"iC:<W\r\u0005\u0002D\r6\tAI\u0003\u0002F+\u0005!1m\u001c:f\u0013\t9EIA\u0006Ti\u0006$Xm\u00115b]\u001e,\u0007FA\u0002J!\tQ5+D\u0001L\u0015\taU*A\u0006b]:|G/\u0019;j_:\u001c(B\u0001(P\u0003\u0019\u0019w.\\7p]*\u0011\u0001+U\u0001\u0007O>|w\r\\3\u000b\u0003I\u000b1aY8n\u0013\t!6JA\tWSNL'\r\\3G_J$Vm\u001d;j]\u001e\u001c2\u0001\u0002,_!\t9F,D\u0001Y\u0015\tI&,\u0001\u0003mC:<'\"A.\u0002\t)\fg/Y\u0005\u0003;b\u0013aa\u00142kK\u000e$\bCA0g\u001d\t\u00017M\u0004\u00021C&\u0011!mF\u0001\u0007KZ,g\u000e^:\n\u0005\u0011,\u0017!D#wK:$H*[:uK:,'O\u0003\u0002c/%\u0011q\r\u001b\u0002\u001b%\u0016\f7\r^5wK\u001e\u0013x.\u001e9Fm\u0016tG\u000fT5ti\u0016tWM\u001d\u0006\u0003I\u0016\fa\u0002];tQJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002l_6\tAN\u0003\u0002\u0015[*\u0011a.F\u0001\u0004CBL\u0017B\u00019m\u0005i\u0001Vo\u001d5Tk\n\u001c8M]5qi&|gNU3q_NLGo\u001c:z\u000359XM\u0019)vg\"\u001cE.[3oiB\u0011qd]\u0005\u0003iN\u0011QbV3c!V\u001c\bn\u00117jK:$\u0018A\u00049vg\"\u001cVM]5bY&TXM\u001d\t\u0003ojl\u0011\u0001\u001f\u0006\u0003sV\tAA[:p]&\u00111\u0010\u001f\u0002\u000f!V\u001c\bnU3sS\u0006d\u0017N_3s\u0003=!W\r\\3hCRLwN\\*u_J,\u0007c\u0001@\u0002\u00065\tqPC\u0002o\u0003\u0003Q1!a\u0001\u0018\u0003\u0011)8/\u001a:\n\u0007\u0005\u001dqPA\bEK2,w-\u0019;j_:\u001cFo\u001c:f\u0003\u0015\u0019Gn\\2l!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t5\u0006!A/[7f\u0013\u0011\t)\"a\u0004\u0003\u000b\rcwnY6\u0015\u0019\u0005e\u00111DA\u000f\u0003?\t\t#a\t\u0011\u0005}!\u0001\"B5\u000b\u0001\u0004Q\u0007\"B9\u000b\u0001\u0004\u0011\b\"B;\u000b\u0001\u00041\b\"\u0002?\u000b\u0001\u0004i\bbBA\u0005\u0015\u0001\u0007\u00111\u0002\u0015\u0004\u0015\u0005\u001d\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0007S:TWm\u0019;\u000b\u0005\u0005E\u0012a\u00026bW\u0006\u0014H/Y\u0005\u0005\u0003k\tYC\u0001\u0004J]*,7\r^\u0001\u0010O\u0016$H)\u001a4bk2$xI]8vaR\u0011\u00111\b\t\u0005\u0003{\ty$D\u0001f\u0013\r\t\t%\u001a\u0002\u0006\u000fJ|W\u000f]\u0001\u000ee\u0016\f7\r^5wK\u00163XM\u001c;\u0015\t\u0005\u001d\u0013\u0011\f\t\u0007\u0003\u0013\ny%a\u0015\u000e\u0005\u0005-#bAA'7\u0005y!/Z1di&4Xm\u001d;sK\u0006l7/\u0003\u0003\u0002R\u0005-#!\u0003)vE2L7\u000f[3s!\r9\u0016QK\u0005\u0004\u0003/B&\u0001\u0002,pS\u0012Dq!a\u0017\r\u0001\u0004\ti&A\u0003fm\u0016tG\u000f\u0005\u0003\u0002>\u0005}\u0013bAA1K\n)QI^3oi\u0006Q\u0011n\u001d%b]\u0012d\u0017N\\4\u0015\t\u0005\u001d\u0014Q\u000e\t\u0004G\u0005%\u0014bAA6I\t9!i\\8mK\u0006t\u0007bBA.\u001b\u0001\u0007\u0011QL\u0001\u0011g\u0016tGMT8uS\u001aL7-\u0019;j_:$b!a\u001d\u0002|\u0005-\u0005CBA%\u0003\u001f\n)\bE\u0002$\u0003oJ1!!\u001f%\u0005\u0011)f.\u001b;\t\u000f\u0005ud\u00021\u0001\u0002\u0000\u0005\u0001\u0002/^:i'V\u00147o\u0019:jaRLwN\u001c\t\u0005\u0003\u0003\u000b9)\u0004\u0002\u0002\u0004*\u0019\u0011QQ7\u0002\u000b5|G-\u001a7\n\t\u0005%\u00151\u0011\u0002\u0011!V\u001c\bnU;cg\u000e\u0014\u0018\u000e\u001d;j_:Dq!!$\u000f\u0001\u0004\ty)\u0001\tti\u0006$Xm\u00115b]\u001e,WI^3oiB!\u0011\u0011SAL\u001b\t\t\u0019JC\u0002\u0002\u0016V\taa\u00195b]\u001e,\u0017\u0002BAM\u0003'\u0013\u0001c\u0015;bi\u0016\u001c\u0005.\u00198hK\u00163XM\u001c;\u0002\u001b\u0005\u001c\b+^:i%\u0016\fX/Z:u)\u0019\ty*!*\u0002(B\u0019q$!)\n\u0007\u0005\r6CA\u0006QkND'+Z9vKN$\b\"B!\u0010\u0001\u0004\u0011\u0005bBA?\u001f\u0001\u0007\u0011qP\u0001\bCN\u0014\u0015\u0010^3t)\u0019\ti+!/\u0002<B)1%a,\u00024&\u0019\u0011\u0011\u0017\u0013\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\r\n),C\u0002\u00028\u0012\u0012AAQ=uK\")\u0011\t\u0005a\u0001\u0005\"9\u0011Q\u0010\tA\u0002\u0005}\u0014aB;sO\u0016t7-\u001f\u000b\u0005\u0003\u0003\f9\rE\u0002 \u0003\u0007L1!!2\u0014\u0005-\u0001Vo\u001d5Ve\u001e,gnY=\t\u000b\u0005\u000b\u0002\u0019\u0001\"")
public class PushListener
implements EventListener.ReactiveGroupEventListener {
    private final PushSubscriptionRepository pushRepository;
    private final WebPushClient webPushClient;
    private final PushSerializer pushSerializer;
    private final DelegationStore delegationStore;
    private final Clock clock;

    @VisibleForTesting
    public static String extractTopic(StateChange stateChange) {
        return PushListener$.MODULE$.extractTopic(stateChange);
    }

    public void event(Event event) throws Exception {
        super.event(event);
    }

    public Group getDefaultGroup() {
        return new PushListenerGroup();
    }

    public Publisher<Void> reactiveEvent(Event event) {
        Event event2 = event;
        if (event2 instanceof StateChangeEvent) {
            StateChangeEvent stateChangeEvent = (StateChangeEvent)event2;
            SFlux qual$1 = SMono$.MODULE$.just((Object)stateChangeEvent.username()).concatWith(this.delegationStore.authorizedUsers(stateChangeEvent.username()));
            Function1 & Serializable x$12 = (Function1 & Serializable)username -> $this.pushRepository.list(username);
            int x$22 = qual$1.flatMap$default$2();
            int x$32 = qual$1.flatMap$default$3();
            boolean x$4 = qual$1.flatMap$default$4();
            SFlux qual$2 = qual$1.flatMap((Function1)x$12, x$22, x$32, x$4).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PushListener.$anonfun$reactiveEvent$2(this, x$1))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.validated()));
            Function1 & Serializable x$5 = (Function1 & Serializable)x$3 -> this.sendNotification((PushSubscription)x$3, stateChangeEvent);
            int x$6 = 16;
            int x$7 = qual$2.flatMap$default$3();
            boolean x$8 = qual$2.flatMap$default$4();
            return package$.MODULE$.publisherUnit2PublisherVoid((MapablePublisher)qual$2.flatMap((Function1)x$5, 16, x$7, x$8).then());
        }
        return SMono$.MODULE$.empty();
    }

    public boolean isHandling(Event event) {
        return event instanceof StateChangeEvent;
    }

    private Publisher<BoxedUnit> sendNotification(PushSubscription pushSubscription, StateChangeEvent stateChangeEvent) {
        return (Publisher)stateChangeEvent.asStateChange().filter((Set<TypeName>)pushSubscription.types().toSet()).fold((Function0 & Serializable)() -> SMono$.MODULE$.empty(), (Function1 & Serializable)stateChange -> SMono$.MODULE$.apply($this.webPushClient.push(pushSubscription.url(), this.asPushRequest((StateChange)stateChange, pushSubscription))));
    }

    private PushRequest asPushRequest(StateChange stateChange, PushSubscription pushSubscription) {
        Long x$1 = PushTTL$.MODULE$.MAX();
        Some x$2 = new Some((Object)this.urgency(stateChange));
        Some x$3 = new Some((Object)new Refined((Object)PushListener$.MODULE$.extractTopic(stateChange)));
        Option x$42 = pushSubscription.keys().map((Function1 & Serializable)x$4 -> Aes128gcm$.MODULE$);
        byte[] x$5 = this.asBytes(stateChange, pushSubscription);
        return new PushRequest(x$1, x$42, (Option)x$3, (Option)x$2, x$5);
    }

    private byte[] asBytes(StateChange stateChange, PushSubscription pushSubscription) {
        byte[] clearTextPayload = Json$.MODULE$.stringify(this.pushSerializer.serializeSSE(stateChange)).getBytes(StandardCharsets.UTF_8);
        return (byte[])pushSubscription.keys().map((Function1 & Serializable)keys -> keys.encrypt(clearTextPayload)).getOrElse((Function0 & Serializable)() -> clearTextPayload);
    }

    private PushUrgency urgency(StateChange stateChange) {
        if (((IterableOnceOps)stateChange.changes().values().flatMap((Function1 & Serializable)x$5 -> x$5.changes().keys())).toList().contains((Object)EmailDeliveryTypeName$.MODULE$)) {
            return High$.MODULE$;
        }
        return Low$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$reactiveEvent$2(PushListener $this, PushSubscription x$1) {
        return PushSubscriptionHelpers.isNotOutdatedSubscription((PushSubscription)x$1, (Clock)$this.clock);
    }

    @Inject
    public PushListener(PushSubscriptionRepository pushRepository, WebPushClient webPushClient, PushSerializer pushSerializer, DelegationStore delegationStore, Clock clock) {
        this.pushRepository = pushRepository;
        this.webPushClient = webPushClient;
        this.pushSerializer = pushSerializer;
        this.delegationStore = delegationStore;
        this.clock = clock;
    }
}

