/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import cats.Applicative;
import cats.implicits$;
import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailHeader;
import org.apache.james.jmap.mail.EmailHeader$;
import org.apache.james.jmap.mail.MinimalEmailBodyPart;
import org.apache.james.jmap.mail.PartId;
import org.apache.james.jmap.mail.Type;
import org.apache.james.jmap.mime4j.JamesBodyDescriptorBuilder;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class MinimalEmailBodyPart$
implements Serializable {
    public static final MinimalEmailBodyPart$ MODULE$ = new MinimalEmailBodyPart$();
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TEXT_HTML = "text/html";
    private static final String MDN_TYPE = "message/disposition-notification";
    private static final String MULTIPART_ALTERNATIVE = "multipart/alternative";
    private static final String FILENAME_PREFIX = "name";
    private static final Properties defaultProperties = Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"partId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"blobId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"size")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"type")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"charset")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"disposition")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"cid")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"language")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"location")).value()))}));
    private static final Properties allowedProperties = MODULE$.defaultProperties().$plus$plus(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"subParts")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"headers")).value()))})));

    public String TEXT_PLAIN() {
        return TEXT_PLAIN;
    }

    public String TEXT_HTML() {
        return TEXT_HTML;
    }

    public String MDN_TYPE() {
        return MDN_TYPE;
    }

    public String MULTIPART_ALTERNATIVE() {
        return MULTIPART_ALTERNATIVE;
    }

    public String FILENAME_PREFIX() {
        return FILENAME_PREFIX;
    }

    public Properties defaultProperties() {
        return defaultProperties;
    }

    public Properties allowedProperties() {
        return allowedProperties;
    }

    public Try<MinimalEmailBodyPart> ofMessage(Option<Properties> properties, ZoneId zoneId, BlobId blobId, MessageResult message) {
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        defaultMessageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        defaultMessageBuilder.setBodyDescriptorBuilder((BodyDescriptorBuilder)new JamesBodyDescriptorBuilder(null, (FieldParser<? extends ParsedField>)LenientFieldParser.getParser(), DecodeMonitor.SILENT));
        defaultMessageBuilder.setBodyFactory((BodyFactory)new BasicBodyFactory(Email$.MODULE$.defaultCharset()));
        Try mime4JMessage = Try$.MODULE$.apply((Function0 & Serializable)() -> defaultMessageBuilder.parseMessage(message.getFullContent().getInputStream()));
        return mime4JMessage.flatMap((Function1 & Serializable)x$1 -> MODULE$.of(properties, zoneId, blobId, (Message)x$1));
    }

    public Try<MinimalEmailBodyPart> of(Option<Properties> properties, ZoneId zoneId, BlobId blobId, Message message) {
        return this.of(properties, zoneId, blobId, new PartId((Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)1))).value()), (Entity)message).map((Function1 & Serializable)x$2 -> (MinimalEmailBodyPart)x$2._1());
    }

    private Try<Tuple2<MinimalEmailBodyPart, PartId>> of(Option<Properties> properties, ZoneId zoneId, BlobId blobId2, PartId partId, Entity entity2) {
        Body body = entity2.getBody();
        if (body instanceof Multipart) {
            Multipart multipart = (Multipart)body;
            Try scanResults = (Try)implicits$.MODULE$.toTraverseOps(CollectionConverters$.MODULE$.ListHasAsScala(multipart.getBodyParts()).asScala().toList().scanLeft((Object)new Success((Object)new Tuple2((Object)None$.MODULE$, (Object)partId)), (Function2 & Serializable)(acc, entity) -> MODULE$.traverse(properties, zoneId, blobId2, (Try<Tuple2<Option<MinimalEmailBodyPart>, PartId>>)acc, (Entity)entity)), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForTry());
            Try highestPartIdValidation = scanResults.map((Function1 & Serializable)list -> (PartId)list.map((Function1 & Serializable)x$3 -> (PartId)x$3._2()).reverse().headOption().getOrElse((Function0 & Serializable)() -> partId));
            Try childrenValidation = scanResults.map((Function1 & Serializable)list -> list.flatMap((Function1 & Serializable)x$4 -> (Option)x$4._1()));
            return this.zip(childrenValidation, highestPartIdValidation).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    List children = (List)tuple2._1();
                    PartId highestPartId = (PartId)tuple2._2();
                    return MODULE$.of((Option<BlobId>)None$.MODULE$, partId, entity2, (Option<List<MinimalEmailBodyPart>>)new Some((Object)children)).map((Function1 & Serializable)part -> new Tuple2(part, (Object)highestPartId));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return BlobId$.MODULE$.of(blobId2, partId).flatMap((Function1 & Serializable)blobId -> MODULE$.of((Option<BlobId>)new Some(blobId), partId, entity2, (Option<List<MinimalEmailBodyPart>>)None$.MODULE$)).map((Function1 & Serializable)part -> new Tuple2(part, (Object)partId));
    }

    private Try<Tuple2<Option<MinimalEmailBodyPart>, PartId>> traverse(Option<Properties> properties, ZoneId zoneId, BlobId blobId, Try<Tuple2<Option<MinimalEmailBodyPart>, PartId>> acc, Entity entity) {
        return acc.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PartId previousPartId = (PartId)tuple2._2();
                PartId partId = previousPartId.next();
                return MODULE$.of(properties, zoneId, blobId, partId, entity).map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        MinimalEmailBodyPart part = (MinimalEmailBodyPart)tuple2._1();
                        PartId partId = (PartId)tuple2._2();
                        return new Tuple2((Object)new Some((Object)part), (Object)partId);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Try<MinimalEmailBodyPart> of(Option<BlobId> blobId, PartId partId, Entity entity, Option<List<MinimalEmailBodyPart>> subParts) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> new MinimalEmailBodyPart(partId, blobId, (List<EmailHeader>)CollectionConverters$.MODULE$.ListHasAsScala(entity.getHeader().getFields()).asScala().toList().map((Function1 & Serializable)x$5 -> EmailHeader$.MODULE$.apply((Field)x$5)), entity.getMimeType(), subParts, entity));
    }

    private <A, B> Try<Tuple2<A, B>> zip(Try<A> a, Try<B> b) {
        return a.flatMap((Function1 & Serializable)aValue -> b.map((Function1 & Serializable)bValue -> new Tuple2(aValue, bValue)));
    }

    public MinimalEmailBodyPart apply(PartId partId, Option<BlobId> blobId, List<EmailHeader> headers, String type, Option<List<MinimalEmailBodyPart>> subParts, Entity entity) {
        return new MinimalEmailBodyPart(partId, blobId, headers, type, subParts, entity);
    }

    public Option<Tuple6<PartId, Option<BlobId>, List<EmailHeader>, Type, Option<List<MinimalEmailBodyPart>>, Entity>> unapply(MinimalEmailBodyPart x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.partId(), x$0.blobId(), x$0.headers(), (Object)new Type(x$0.type()), x$0.subParts(), (Object)x$0.entity()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MinimalEmailBodyPart$.class);
    }

    private MinimalEmailBodyPart$() {
    }
}

